Option Strict Off
Option Explicit On
Friend Class Step2
	Inherits System.Windows.Forms.Form
	'Step 2 Display characters at the specified position.
	
	Private Sub cmdExit_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdExit.Click
		
		Me.Close()
		
	End Sub
	
	'Clear the text on the window
	'
	Private Sub Command1_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Command1.Click
		
		OPOSLineDisplay1.ClearText()
		
	End Sub
	
	'Display the text as specified.
	'
	Private Sub Command2_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Command2.Click
		
		'Display the text as specified.
		OPOSLineDisplay1.DisplayTextAt(1, 5, "Hello OPOS.", DISP_DT_NORMAL)
		
		'As follows, there are ways of displaying after setting the property.
		'    OPOSLineDisplay1.CursorRow = 0
		'    OPOSLineDisplay1.CursorColumn = 10
		'    OPOSLineDisplay1.DisplayText "Hello OPOS.", DISP_DT_NORMAL
		
	End Sub
	
	'Acquired the character of cursor position
	'
	Private Sub Command3_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Command3.Click
		Dim temp As Integer
		
		'The present cursor position is set up.
		OPOSLineDisplay1.CursorRow = 1
		OPOSLineDisplay1.CursorColumn = 5
		
		'The character of the present cursor position is acquired.
		OPOSLineDisplay1.ReadCharacterAtCursor(temp)
		Text1.Text = Hex(temp) 'hexadecimal digit
		
	End Sub
	
	Private Sub Step2_Load(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles MyBase.Load
		
		With OPOSLineDisplay1
			.Open("Unit1")
			.ClaimDevice(1000)
			If .CapPowerReporting <> OPOS_PR_NONE Then
				.PowerNotify = OPOS_PN_ENABLED
			End If
			.DeviceEnabled = True
		End With
		
	End Sub
	
	Private Sub Step2_FormClosed(ByVal eventSender As System.Object, ByVal eventArgs As System.Windows.Forms.FormClosedEventArgs) Handles Me.FormClosed
		
		With OPOSLineDisplay1
			.DeviceEnabled = False
			.ReleaseDevice()
			.Close()
		End With
		
	End Sub
End Class