Option Strict Off
Option Explicit On
Friend Class Step7
	Inherits System.Windows.Forms.Form
	'Step 7 Adding error handlers.
	
	Private Sub cmdExit_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdExit.Click
		
		Me.Close()
		
	End Sub
	
	'Clear the text on the window
	'
	Private Sub Command1_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Command1.Click
		
		OPOSLineDisplay1.ClearText()
		
	End Sub
	
	'Display the text as specified.
	'
	Private Sub Command2_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Command2.Click
		
		OPOSLineDisplay1.DisplayTextAt(1, 5, "Hello OPOS.", DISP_DT_NORMAL)
		
	End Sub
	
	
	'Display the blinking text
	'
	Private Sub Command3_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Command3.Click
		
		OPOSLineDisplay1.DisplayText("Blink", DISP_DT_BLINK)
		
	End Sub
	
	'Teletype display
	'
	Private Sub Command4_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Command4.Click
		
		OPOSLineDisplay1.InterCharacterWait = 1000
		OPOSLineDisplay1.DisplayText("Teletype", DISP_DT_NORMAL)
		
	End Sub
	
	Private Sub Command4_Leave(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Command4.Leave
		
		OPOSLineDisplay1.InterCharacterWait = 0
		
	End Sub
	
	'Scrolled display
	'
	Private Sub Command5_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Command5.Click
		Dim Index As Short = Command5.GetIndex(eventSender)
		
		If Index = 0 Then
			' Move one character to the left side
			OPOSLineDisplay1.ScrollText(DISP_ST_LEFT, 1)
		Else
			' Move two characters to the right side
			OPOSLineDisplay1.ScrollText(DISP_ST_RIGHT, 2)
		End If
		
	End Sub
	
	
	'Window control
	'
	Private Sub Command6_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Command6.Click
		
		With OPOSLineDisplay1
			.CreateWindow(1, 10, 1, 10, 1, 34)
			.MarqueeFormat = DISP_MF_WALK
			.MarqueeType = DISP_MT_INIT
			.MarqueeRepeatWait = 1000
			.MarqueeUnitWait = 100
			.DisplayText("Sale! 50%-20% OFF!", DISP_DT_NORMAL)
			.MarqueeType = DISP_MT_LEFT
			
			MsgBox("When pressing OK, it ends")
			
			.MarqueeType = DISP_MT_INIT
			.DestroyWindow()
		End With
		
	End Sub
	
	Private Sub Step7_Load(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles MyBase.Load
		
		With OPOSLineDisplay1
			.Open("Unit1")
			' Error check
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("This device has not been registered, or cannot use.")
				GoTo LoadError
			End If
			
			.ClaimDevice(1000)
			' Error check
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Fails to get the exclusive right for the device.")
				GoTo LoadError
			End If
			
			' If support the CapPowerReporting, enable the Power Reporting Requirements.
			If .CapPowerReporting <> OPOS_PR_NONE Then
				.PowerNotify = OPOS_PN_ENABLED
			End If
			
			.DeviceEnabled = True
			' Error check
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Now the device is disable to use.")
				GoTo LoadError
			End If
		End With
		
		Exit Sub
		
LoadError: 
		' Nothing can be used.
		Dim OBJ As Object
		'All objects on the form
		For	Each OBJ In Me.Controls
			'Invalid exept for OPOS OCX
			If OBJ.Name <> "OPOSLineDisplay1" Then
				OBJ.Enabled = False
			End If
		Next OBJ
		cmdExit.Enabled = True 'Only the exit button is enabled.
		
	End Sub
	
	Private Sub Step7_FormClosed(ByVal eventSender As System.Object, ByVal eventArgs As System.Windows.Forms.FormClosedEventArgs) Handles Me.FormClosed
		
		With OPOSLineDisplay1
			.ClearText()
			.DeviceEnabled = False
			.ReleaseDevice()
			.Close()
		End With
		
	End Sub
	
	Private Sub OPOSLineDisplay1_StatusUpdateEvent(ByVal eventSender As System.Object, ByVal eventArgs As AxOposLineDisplay_CCO._IOPOSLineDisplayEvents_StatusUpdateEventEvent) Handles OPOSLineDisplay1.StatusUpdateEvent
		
		'The Power Reporting Requirements fires the event when the device power status is changed.
		Select Case eventArgs.Data
			Case OPOS_SUE_POWER_ONLINE ' The device is powered on.
				MsgBox("The device is powered on.")
			Case OPOS_SUE_POWER_OFF ' The device is powered off, or unconnected.
				MsgBox("The device is powered off, or unconnected.")
			Case OPOS_SUE_POWER_OFFLINE ' The device is powered on, but disable to operate.
				MsgBox("The device is powered on, but disable to operate..")
			Case OPOS_SUE_POWER_OFF_OFFLINE ' The device is powered off or off-line.
				MsgBox("The device is powered off or off-line.")
		End Select
		
	End Sub
End Class