Option Strict Off
Option Explicit On
Module OPOS
	
	' /////////////////////////////////////////////////////////////////////
	' //
	' // Opos.h
	' //
	' //   General header file for OPOS Applications.
	' //
	' // Modification history
	' // ------------------------------------------------------------------
	' // 1995-12-08 OPOS Release 1.0                                   CRM
	' // 1997-06-04 OPOS Release 1.2                                   CRM
	' //   Add OPOS_FOREVER.
	' //   Add BinaryConversion constants.
	' // 1998-03-06 OPOS Release 1.3                                   CRM
	' //   Add CapPowerReporting, PowerState, and PowerNotify constants.
	' //   Add power reporting constants for StatusUpdateEvent.
	' // 2000-09-24 OPOS Release 1.5                                   CRM
	' //   Add OpenResult status constants.
	' // 2004-10-26 OPOS Release 1.8                                   CRM
	' //   Add "ResultCodeExtended" statistics constant.
	' // 2005-04-29 OPOS Release 1.9                                   CRM
	' //   Add CompareFirmwareVersion's Result constants.
	' //   Add StatusUpdateEvent and ResultCodeExtended constants
	' //     for firmware update.
	' // 2006-03-15 OPOS Release 1.10                                  CRM
	' //   Add another constant for firmware update.
	' // 2007-01-30 OPOS Release 1.11                                  CRM
	' //   Add ResultCode constant for deprecation.
	' // 2008-08-30 OPOS Release 1.12                                  CRM
	' //   Comment updates.
	' //
	' /////////////////////////////////////////////////////////////////////
	
	' /////////////////////////////////////////////////////////////////////
	' // OPOS "State" Property Constants
	' /////////////////////////////////////////////////////////////////////
	
	Public Const OPOS_S_CLOSED As Integer = 1
	Public Const OPOS_S_IDLE As Integer = 2
	Public Const OPOS_S_BUSY As Integer = 3
	Public Const OPOS_S_ERROR As Integer = 4
	
	' /////////////////////////////////////////////////////////////////////
	' // OPOS "ResultCode" Property Constants
	' /////////////////////////////////////////////////////////////////////
	
	Public Const OPOS_SUCCESS As Integer = 0
	Public Const OPOS_E_CLOSED As Integer = 101
	Public Const OPOS_E_CLAIMED As Integer = 102
	Public Const OPOS_E_NOTCLAIMED As Integer = 103
	Public Const OPOS_E_NOSERVICE As Integer = 104
	Public Const OPOS_E_DISABLED As Integer = 105
	Public Const OPOS_E_ILLEGAL As Integer = 106
	Public Const OPOS_E_NOHARDWARE As Integer = 107
	Public Const OPOS_E_OFFLINE As Integer = 108
	Public Const OPOS_E_NOEXIST As Integer = 109
	Public Const OPOS_E_EXISTS As Integer = 110
	Public Const OPOS_E_FAILURE As Integer = 111
	Public Const OPOS_E_TIMEOUT As Integer = 112
	Public Const OPOS_E_BUSY As Integer = 113
	Public Const OPOS_E_EXTENDED As Integer = 114
	Public Const OPOS_E_DEPRECATED As Integer = 115 ' // (added in 1.11)
	
	Public Const OPOSERR As Integer = 100 ' // Base for ResultCode errors.
	Public Const OPOSERREXT As Integer = 200 ' // Base for ResultCodeExtendedErrors.
	
	' /////////////////////////////////////////////////////////////////////
	' // OPOS "ResultCodeExtended" Property Constants
	' /////////////////////////////////////////////////////////////////////
	
	' // The following applies to ResetStatistics and UpdateStatistics.
	Public Const OPOS_ESTATS_ERROR As Integer = 280 ' // (added in 1.8)
	Public Const OPOS_ESTATS_DEPENDENCY As Integer = 282 ' // (added in 1.10)
	' // The following applies to CompareFirmwareVersion and UpdateFirmware.
	Public Const OPOS_EFIRMWARE_BAD_FILE As Integer = 281 ' // (added in 1.9)
	
	' /////////////////////////////////////////////////////////////////////
	' // OPOS "OpenResult" Property Constants (added in 1.5)
	' /////////////////////////////////////////////////////////////////////
	
	' // The following can be set by the control object.
	' //  - Control Object already open.
	Public Const OPOS_OR_ALREADYOPEN As Integer = 301
	' //  - The registry does not contain a key for the specified device name.
	Public Const OPOS_OR_REGBADNAME As Integer = 302
	' //  - Could not read the device name key's default value, or
	' //     could not convert this Prog ID to a valid Class ID.
	Public Const OPOS_OR_REGPROGID As Integer = 303
	' //  - Could not create a service object instance, or
	' //     could not get its IDispatch interface.
	Public Const OPOS_OR_CREATE As Integer = 304
	' //  - The service object does not support one or more of the
	' //     method required by its release.
	Public Const OPOS_OR_BADIF As Integer = 305
	' //  - The service object returned a failure status from its
	' //     open call, but doesn't have a more specific failure code.
	Public Const OPOS_OR_FAILEDOPEN As Integer = 306
	' //  - The service object major version number is not 1.
	Public Const OPOS_OR_BADVERSION As Integer = 307
	
	' // The following can be returned by the service object if it
	' // returns a failure status from its open call.
	' //  - Port access required at open, but configured port
	' //     is invalid or inaccessible.
	Public Const OPOS_ORS_NOPORT As Integer = 401
	' //  - Service Object does not support the specified device.
	Public Const OPOS_ORS_NOTSUPPORTED As Integer = 402
	' //  - Configuration information error.
	Public Const OPOS_ORS_CONFIG As Integer = 403
	' //  - Errors greater than this value are SO-specific.
	Public Const OPOS_ORS_SPECIFIC As Integer = 450
	
	' /////////////////////////////////////////////////////////////////////
	' // OPOS "BinaryConversion" Property Constants (added in 1.2)
	' /////////////////////////////////////////////////////////////////////
	
	Public Const OPOS_BC_NONE As Integer = 0
	Public Const OPOS_BC_NIBBLE As Integer = 1
	Public Const OPOS_BC_DECIMAL As Integer = 2
	
	' /////////////////////////////////////////////////////////////////////
	' // "CheckHealth" Method: "Level" Parameter Constants
	' /////////////////////////////////////////////////////////////////////
	
	Public Const OPOS_CH_INTERNAL As Integer = 1
	Public Const OPOS_CH_EXTERNAL As Integer = 2
	Public Const OPOS_CH_INTERACTIVE As Integer = 3
	
	' /////////////////////////////////////////////////////////////////////
	' // OPOS "CapPowerReporting", "PowerState", "PowerNotify" Property
	' //   Constants (added in 1.3)
	' /////////////////////////////////////////////////////////////////////
	
	Public Const OPOS_PR_NONE As Integer = 0
	Public Const OPOS_PR_STANDARD As Integer = 1
	Public Const OPOS_PR_ADVANCED As Integer = 2
	
	Public Const OPOS_PN_DISABLED As Integer = 0
	Public Const OPOS_PN_ENABLED As Integer = 1
	
	Public Const OPOS_PS_UNKNOWN As Integer = 2000
	Public Const OPOS_PS_ONLINE As Integer = 2001
	Public Const OPOS_PS_OFF As Integer = 2002
	Public Const OPOS_PS_OFFLINE As Integer = 2003
	Public Const OPOS_PS_OFF_OFFLINE As Integer = 2004
	
	' /////////////////////////////////////////////////////////////////////
	' // "CompareFirmwareVersion" Method: "Result" Parameter Constants
	' //   (added in 1.9)
	' /////////////////////////////////////////////////////////////////////
	
	Public Const OPOS_CFV_FIRMWARE_OLDER As Integer = 1
	Public Const OPOS_CFV_FIRMWARE_SAME As Integer = 2
	Public Const OPOS_CFV_FIRMWARE_NEWER As Integer = 3
	Public Const OPOS_CFV_FIRMWARE_DIFFERENT As Integer = 4
	Public Const OPOS_CFV_FIRMWARE_UNKNOWN As Integer = 5
	
	' /////////////////////////////////////////////////////////////////////
	' // "ErrorEvent" Event: "ErrorLocus" Parameter Constants
	' /////////////////////////////////////////////////////////////////////
	
	Public Const OPOS_EL_OUTPUT As Integer = 1
	Public Const OPOS_EL_INPUT As Integer = 2
	Public Const OPOS_EL_INPUT_DATA As Integer = 3
	
	' /////////////////////////////////////////////////////////////////////
	' // "ErrorEvent" Event: "ErrorResponse" Constants
	' /////////////////////////////////////////////////////////////////////
	
	Public Const OPOS_ER_RETRY As Integer = 11
	Public Const OPOS_ER_CLEAR As Integer = 12
	Public Const OPOS_ER_CONTINUEINPUT As Integer = 13
	
	' /////////////////////////////////////////////////////////////////////
	' // "StatusUpdateEvent" Event: Common "Status" Constants
	' /////////////////////////////////////////////////////////////////////
	
	Public Const OPOS_SUE_POWER_ONLINE As Integer = 2001 ' // (added in 1.3)
	Public Const OPOS_SUE_POWER_OFF As Integer = 2002 ' // (added in 1.3)
	Public Const OPOS_SUE_POWER_OFFLINE As Integer = 2003 ' // (added in 1.3)
	Public Const OPOS_SUE_POWER_OFF_OFFLINE As Integer = 2004 ' // (added in 1.3)
	
	Public Const OPOS_SUE_UF_PROGRESS As Integer = 2100 ' // (added in 1.9)
	Public Const OPOS_SUE_UF_COMPLETE As Integer = 2200 ' // (added in 1.9)
	Public Const OPOS_SUE_UF_COMPLETE_DEV_NOT_RESTORED As Integer = 2205 ' // (added in 1.9)
	Public Const OPOS_SUE_UF_FAILED_DEV_OK As Integer = 2201 ' // (added in 1.9)
	Public Const OPOS_SUE_UF_FAILED_DEV_UNRECOVERABLE As Integer = 2202 ' // (added in 1.9)
	Public Const OPOS_SUE_UF_FAILED_DEV_NEEDS_FIRMWARE As Integer = 2203 ' // (added in 1.9)
	Public Const OPOS_SUE_UF_FAILED_DEV_UNKNOWN As Integer = 2204 ' // (added in 1.9)
	
	' /////////////////////////////////////////////////////////////////////
	' // General Constants
	' /////////////////////////////////////////////////////////////////////
	
	Public Const OPOS_FOREVER As Integer = -1 ' // (added in 1.2)
	
	' /////////////////////////////////////////////////////////////////////
	' //
	' // OposCash.h
	' //
	' //   Cash Drawer header file for OPOS Applications.
	' //
	' // Modification history
	' // ------------------------------------------------------------------
	' // 1995-12-08 OPOS Release 1.0                                   CRM
	' // 1998-03-06 OPOS Release 1.3                                   CRM
	' //
	' /////////////////////////////////////////////////////////////////////
	
	' /////////////////////////////////////////////////////////////////////
	' // "StatusUpdateEvent" Event Constants
	' /////////////////////////////////////////////////////////////////////
	
	Public Const CASH_SUE_DRAWERCLOSED As Integer = 0
	Public Const CASH_SUE_DRAWEROPEN As Integer = 1
	
	' /////////////////////////////////////////////////////////////////////
	' //
	' // OposChk.h
	' //
	' //   Check Scanner header file for OPOS Applications.
	' //
	' // Modification history
	' // ------------------------------------------------------------------
	' // 2002-08-17 OPOS Release 1.7                                   CRM
	' // 2005-04-29 OPOS Release 1.9                                   CRM
	' //   Added Constrast constants.
	' //
	' /////////////////////////////////////////////////////////////////////
	
	' /////////////////////////////////////////////////////////////////////
	' // "CapColor" Capability Constants
	' /////////////////////////////////////////////////////////////////////
	
	Public Const CHK_CCL_MONO As Integer = &H1
	Public Const CHK_CCL_GRAYSCALE As Integer = &H2
	Public Const CHK_CCL_16 As Integer = &H4
	Public Const CHK_CCL_256 As Integer = &H8
	Public Const CHK_CCL_FULL As Integer = &H10
	
	' /////////////////////////////////////////////////////////////////////
	' // "CapImageFormat" Capability Constants
	' /////////////////////////////////////////////////////////////////////
	
	Public Const CHK_CIF_NATIVE As Integer = &H1
	Public Const CHK_CIF_TIFF As Integer = &H2
	Public Const CHK_CIF_BMP As Integer = &H4
	Public Const CHK_CIF_JPEG As Integer = &H8
	Public Const CHK_CIF_GIF As Integer = &H10
	
	' /////////////////////////////////////////////////////////////////////
	' // "Color" Property Constants
	' /////////////////////////////////////////////////////////////////////
	
	Public Const CHK_CL_MONO As Integer = 1
	Public Const CHK_CL_GRAYSCALE As Integer = 2
	Public Const CHK_CL_16 As Integer = 3
	Public Const CHK_CL_256 As Integer = 4
	Public Const CHK_CL_FULL As Integer = 5
	
	' /////////////////////////////////////////////////////////////////////
	' // "Constrast" Property Constants (added in 1.9)
	' /////////////////////////////////////////////////////////////////////
	
	Public Const CHK_AUTOMATIC_CONTRAST As Integer = -1
	
	' /////////////////////////////////////////////////////////////////////
	' // "ImageFormat" Property Constants
	' /////////////////////////////////////////////////////////////////////
	
	Public Const CHK_IF_NATIVE As Integer = 1
	Public Const CHK_IF_TIFF As Integer = 2
	Public Const CHK_IF_BMP As Integer = 3
	Public Const CHK_IF_JPEG As Integer = 4
	Public Const CHK_IF_GIF As Integer = 5
	
	' /////////////////////////////////////////////////////////////////////
	' // "ImageMemoryStatus" Property Constants
	' /////////////////////////////////////////////////////////////////////
	
	Public Const CHK_IMS_EMPTY As Integer = 1
	Public Const CHK_IMS_OK As Integer = 2
	Public Const CHK_IMS_FULL As Integer = 3
	
	' /////////////////////////////////////////////////////////////////////
	' // "MapMode" Property Constants
	' /////////////////////////////////////////////////////////////////////
	
	Public Const CHK_MM_DOTS As Integer = 1
	Public Const CHK_MM_TWIPS As Integer = 2
	Public Const CHK_MM_ENGLISH As Integer = 3
	Public Const CHK_MM_METRIC As Integer = 4
	
	' /////////////////////////////////////////////////////////////////////
	' // "ClearImage" Method Constants:
	' /////////////////////////////////////////////////////////////////////
	
	' //   "By" Parameter
	Public Const CHK_CLR_ALL As Integer = 1
	Public Const CHK_CLR_BY_FILEID As Integer = 2
	Public Const CHK_CLR_BY_FILEINDEX As Integer = 3
	Public Const CHK_CLR_BY_IMAGETAGDATA As Integer = 4
	
	' /////////////////////////////////////////////////////////////////////
	' // "DefineCropArea" Method Constants:
	' /////////////////////////////////////////////////////////////////////
	
	' // "CropAreaID" Parameter or index number
	Public Const CHK_CROP_AREA_ENTIRE_IMAGE As Integer = -1
	Public Const CHK_CROP_AREA_RESET_ALL As Integer = -2
	
	' // "CX" Parameter or integer width
	Public Const CHK_CROP_AREA_RIGHT As Integer = -1
	
	' // "CY" Parameter or integer height
	Public Const CHK_CROP_AREA_BOTTOM As Integer = -1
	
	' /////////////////////////////////////////////////////////////////////
	' // "RetrieveMemory" Method Constants:
	' /////////////////////////////////////////////////////////////////////
	
	' // "By" Parameter
	Public Const CHK_LOCATE_BY_FILEID As Integer = 1
	Public Const CHK_LOCATE_BY_FILEINDEX As Integer = 2
	Public Const CHK_LOCATE_BY_IMAGETAGDATA As Integer = 3
	
	' /////////////////////////////////////////////////////////////////////
	' // "RetrieveImage" and "StoreImage" Method Constant:
	' /////////////////////////////////////////////////////////////////////
	
	' // "CropAreaID" Parameter or index number
	' //const LONG CHK_CROP_AREA_ENTIRE_IMAGE   = -1; //(Defined above)
	
	' /////////////////////////////////////////////////////////////////////
	' // "StatusUpdateEvent" Event: "Data" Parameter Constant
	' /////////////////////////////////////////////////////////////////////
	
	Public Const CHK_SUE_SCANCOMPLETE As Integer = 11
	
	' /////////////////////////////////////////////////////////////////////
	' // "ResultCodeExtended" Property Constants
	' /////////////////////////////////////////////////////////////////////
	
	Public Const OPOS_ECHK_NOCHECK As Integer = 201 ' // endInsertion
	Public Const OPOS_ECHK_CHECK As Integer = 202 ' // endRemoval
	Public Const OPOS_ECHK_NOROOM As Integer = 203 ' // storeImage
	
	' /////////////////////////////////////////////////////////////////////
	' //
	' // OposDisp.h
	' //
	' //   Line Display header file for OPOS Applications.
	' //
	' // Modification history
	' // ------------------------------------------------------------------
	' // 1995-12-08 OPOS Release 1.0                                   CRM
	' // 1996-03-18 OPOS Release 1.01                                  CRM
	' //   Add DISP_MT_INIT constant and MarqueeFormat constants.
	' // 1996-04-22 OPOS Release 1.1                                   CRM
	' //   Add CapCharacterSet constants for Kana and Kanji.
	' // 2000-09-24 OPOS Release 1.5                                   BKS
	' //   Add CapCharacterSet and CharacterSet constants for Unicode
	' // 2001-07-15 OPOS Release 1.6                                   BKS
	' //   Add CapCursorType, CapReadBack, CapReverse, CursorType
	' //     property constants.
	' //   Add DefineGlyph, DisplayText and DisplayTextAt parameter
	' //     constants.
	' // 2002-08-17 OPOS Release 1.7                                   CRM
	' //   Add DisplayBitmap and SetBitmap parameter constants.
	' // 2004-03-22 OPOS Release 1.8                                   CRM
	' //   Add more constants for CapCursorType and CursorType.
	' // 2004-10-26 Add "CharacterSet" ANSI constant (from 1.5).       CRM
	' //   Add ResultCodeExtended constants (from 1.7).
	' //
	' /////////////////////////////////////////////////////////////////////
	
	' /////////////////////////////////////////////////////////////////////
	' // "CapBlink" Property Constants
	' /////////////////////////////////////////////////////////////////////
	
	Public Const DISP_CB_NOBLINK As Integer = 0
	Public Const DISP_CB_BLINKALL As Integer = 1
	Public Const DISP_CB_BLINKEACH As Integer = 2
	
	' /////////////////////////////////////////////////////////////////////
	' // "CapCharacterSet" Property Constants
	' /////////////////////////////////////////////////////////////////////
	
	Public Const DISP_CCS_NUMERIC As Integer = 0
	Public Const DISP_CCS_ALPHA As Integer = 1
	Public Const DISP_CCS_ASCII As Integer = 998
	Public Const DISP_CCS_KANA As Integer = 10 ' // (added in 1.1)
	Public Const DISP_CCS_KANJI As Integer = 11 ' // (added in 1.1)
	Public Const DISP_CCS_UNICODE As Integer = 997 ' // (added in 1.5)
	
	' /////////////////////////////////////////////////////////////////////
	' // "CapCursorType" Property Constants (added in 1.6)
	' /////////////////////////////////////////////////////////////////////
	
	Public Const DISP_CCT_NONE As Integer = &H0
	Public Const DISP_CCT_FIXED As Integer = &H1
	Public Const DISP_CCT_BLOCK As Integer = &H2
	Public Const DISP_CCT_HALFBLOCK As Integer = &H4
	Public Const DISP_CCT_UNDERLINE As Integer = &H8
	Public Const DISP_CCT_REVERSE As Integer = &H10
	Public Const DISP_CCT_OTHER As Integer = &H20
	Public Const DISP_CCT_BLINK As Integer = &H40 ' // (added in 1.8)
	
	' /////////////////////////////////////////////////////////////////////
	' // "CapReadBack" Property Constants (added in 1.6)
	' /////////////////////////////////////////////////////////////////////
	
	Public Const DISP_CRB_NONE As Integer = &H0
	Public Const DISP_CRB_SINGLE As Integer = &H1
	
	' /////////////////////////////////////////////////////////////////////
	' // "CapReverse" Property Constants (added in 1.6)
	' /////////////////////////////////////////////////////////////////////
	
	Public Const DISP_CR_NONE As Integer = &H0
	Public Const DISP_CR_REVERSEALL As Integer = &H1
	Public Const DISP_CR_REVERSEEACH As Integer = &H2
	
	' /////////////////////////////////////////////////////////////////////
	' // "CharacterSet" Property Constants
	' /////////////////////////////////////////////////////////////////////
	
	Public Const DISP_CS_UNICODE As Integer = 997 ' // (added in 1.5)
	Public Const DISP_CS_ASCII As Integer = 998
	Public Const DISP_CS_WINDOWS As Integer = 999
	Public Const DISP_CS_ANSI As Integer = 999 ' // (added in 1.5)
	
	' /////////////////////////////////////////////////////////////////////
	' // "CursorType" Property Constants (added in 1.6)
	' /////////////////////////////////////////////////////////////////////
	
	Public Const DISP_CT_NONE As Integer = 0
	Public Const DISP_CT_FIXED As Integer = 1
	Public Const DISP_CT_BLOCK As Integer = 2
	Public Const DISP_CT_HALFBLOCK As Integer = 3
	Public Const DISP_CT_UNDERLINE As Integer = 4
	Public Const DISP_CT_REVERSE As Integer = 5
	Public Const DISP_CT_OTHER As Integer = 6
	Public Const DISP_CT_BLINK As Integer = &H10000000 ' // (added in 1.8)
	
	' /////////////////////////////////////////////////////////////////////
	' // "MarqueeType" Property Constants
	' /////////////////////////////////////////////////////////////////////
	
	Public Const DISP_MT_NONE As Integer = 0
	Public Const DISP_MT_UP As Integer = 1
	Public Const DISP_MT_DOWN As Integer = 2
	Public Const DISP_MT_LEFT As Integer = 3
	Public Const DISP_MT_RIGHT As Integer = 4
	Public Const DISP_MT_INIT As Integer = 5 ' // (added in 1.01)
	
	' /////////////////////////////////////////////////////////////////////
	' // "MarqueeFormat" Property Constants (added in 1.01)
	' /////////////////////////////////////////////////////////////////////
	
	Public Const DISP_MF_WALK As Integer = 0
	Public Const DISP_MF_PLACE As Integer = 1
	
	' /////////////////////////////////////////////////////////////////////
	' // "DefineGlyph" Method: "GlyphType" Parameter Constants (added in 1.6)
	' /////////////////////////////////////////////////////////////////////
	
	Public Const DISP_GT_SINGLE As Integer = 1
	
	' /////////////////////////////////////////////////////////////////////
	' // "DisplayText" Method: "Attribute" Property Constants (added in 1.6)
	' // "DisplayTextAt" Method: "Attribute" Property Constants (added in 1.6)
	' /////////////////////////////////////////////////////////////////////
	
	Public Const DISP_DT_NORMAL As Integer = 0
	Public Const DISP_DT_BLINK As Integer = 1
	Public Const DISP_DT_REVERSE As Integer = 2
	Public Const DISP_DT_BLINK_REVERSE As Integer = 3
	
	' /////////////////////////////////////////////////////////////////////
	' // "ScrollText" Method: "Direction" Parameter Constants
	' /////////////////////////////////////////////////////////////////////
	
	Public Const DISP_ST_UP As Integer = 1
	Public Const DISP_ST_DOWN As Integer = 2
	Public Const DISP_ST_LEFT As Integer = 3
	Public Const DISP_ST_RIGHT As Integer = 4
	
	' /////////////////////////////////////////////////////////////////////
	' // "SetDescriptor" Method: "Attribute" Parameter Constants
	' /////////////////////////////////////////////////////////////////////
	
	Public Const DISP_SD_OFF As Integer = 0
	Public Const DISP_SD_ON As Integer = 1
	Public Const DISP_SD_BLINK As Integer = 2
	
	' /////////////////////////////////////////////////////////////////////
	' // "DisplayBitmap" and "SetBitmap" Method Constants (added in 1.7)
	' /////////////////////////////////////////////////////////////////////
	
	' //   "Width" Parameter
	
	Public Const DISP_BM_ASIS As Integer = -11
	
	' //   "AlignmentX" Parameter
	
	Public Const DISP_BM_LEFT As Integer = -1
	Public Const DISP_BM_CENTER As Integer = -2
	Public Const DISP_BM_RIGHT As Integer = -3
	
	' //   "AlignmentY" Parameter
	
	Public Const DISP_BM_TOP As Integer = -1
	' //const LONG DISP_BM_CENTER     = -2;
	Public Const DISP_BM_BOTTOM As Integer = -3
	
	' /////////////////////////////////////////////////////////////////////
	' // "ResultCodeExtended" Property Constants
	' /////////////////////////////////////////////////////////////////////
	
	Public Const OPOS_EDISP_TOOBIG As Integer = 201 ' // DisplayBitmap (added in 1.7)
	Public Const OPOS_EDISP_BADFORMAT As Integer = 202 ' // DisplayBitmap (added in 1.7)
	
	' /////////////////////////////////////////////////////////////////////
	' //
	' // OposEj.h
	' //
	' //   Electronic Journal header file for OPOS Applications.
	' //
	' // Modification history
	' // ------------------------------------------------------------------
	' // 2006-03-15 OPOS Release 1.10                                  CRM
	' // 2008-08-30 OPOS Release 1.12                                  CRM
	' //   Add constant to StatusUpdateEvent.
	' //
	' /////////////////////////////////////////////////////////////////////
	
	' /////////////////////////////////////////////////////////////////////
	' // "CapStation", "Station" Property Constants
	' /////////////////////////////////////////////////////////////////////
	
	Public Const EJ_S_RECEIPT As Integer = &H1
	Public Const EJ_S_SLIP As Integer = &H2
	Public Const EJ_S_JOURNAL As Integer = &H4
	
	' /////////////////////////////////////////////////////////////////////
	' // "retrieveCurrentMarker" Method, "markerType" Parameter Constants
	' // "retrieveMarker" Method, "markerType" Parameter Constants
	' // "retrieveMarkerByDateTime" Method, "markerType" Parameter Constants
	' /////////////////////////////////////////////////////////////////////
	
	Public Const EJ_MT_SESSION_BEG As Integer = 1
	Public Const EJ_MT_SESSION_END As Integer = 2
	Public Const EJ_MT_DOCUMENT As Integer = 3
	Public Const EJ_MT_HEAD As Integer = 4
	Public Const EJ_MT_TAIL As Integer = 5
	
	' /////////////////////////////////////////////////////////////////////
	' // "ResultCodeExtended" Property and "ErrorEvent" Parameter Constants
	' /////////////////////////////////////////////////////////////////////
	
	Public Const OPOS_EEJ_EXISTING As Integer = 201
	Public Const OPOS_EEJ_MEDIUM_FULL As Integer = 202
	Public Const OPOS_EEJ_MULTIPLE_MARKER As Integer = 203
	Public Const OPOS_EEJ_UNINITIALIZED_MEDIUM As Integer = 204
	Public Const OPOS_EEJ_CORRUPTED_MEDIUM As Integer = 205
	Public Const OPOS_EEJ_UNKNOWN_DATAFORMAT As Integer = 206
	Public Const OPOS_EEJ_NOT_ENOUGH_SPACE As Integer = 207
	Public Const OPOS_EEJ_MULTIPLE_MARKERS As Integer = 208
	
	' /////////////////////////////////////////////////////////////////////
	' // "StatusUpdateEvent" "Status" Property Constants
	' /////////////////////////////////////////////////////////////////////
	
	Public Const EJ_SUE_MEDIUM_NEAR_FULL As Integer = 1
	Public Const EJ_SUE_MEDIUM_FULL As Integer = 2
	Public Const EJ_SUE_MEDIUM_REMOVED As Integer = 3
	Public Const EJ_SUE_MEDIUM_INSERTED As Integer = 4
	Public Const EJ_SUE_SUSPENDED As Integer = 5
	Public Const EJ_SUE_IDLE As Integer = 1001 ' // (added in 1.12)
	
	' /////////////////////////////////////////////////////////////////////
	' //
	' // OposLock.h
	' //
	' //   Keylock header file for OPOS Applications.
	' //
	' // Modification history
	' // ------------------------------------------------------------------
	' // 1995-12-08 OPOS Release 1.0                                   CRM
	' // 2007-01-30 OPOS Release 1.11                                  CRM
	' //
	' /////////////////////////////////////////////////////////////////////
	
	' /////////////////////////////////////////////////////////////////////
	' // "KeyPosition" Property Constants
	' // "WaitForKeylockChange" Method: "KeyPosition" Parameter
	' // "StatusUpdateEvent" Event: "Data" Parameter
	' /////////////////////////////////////////////////////////////////////
	
	Public Const LOCK_KP_ANY As Integer = 0 ' // WaitForKeylockChange Only
	Public Const LOCK_KP_ELECTRONIC As Integer = 0 ' // StatusUpdateEvent Only (added in 1.11)
	Public Const LOCK_KP_LOCK As Integer = 1
	Public Const LOCK_KP_NORM As Integer = 2
	Public Const LOCK_KP_SUPR As Integer = 3
	
	' /////////////////////////////////////////////////////////////////////
	' // "CapKeylockType" Property Constants
	' //   Added in 1.11.
	' /////////////////////////////////////////////////////////////////////
	
	Public Const LOCK_KT_STANDARD As Integer = 1
	Public Const LOCK_KT_ELECTRONIC As Integer = 2
	
	' /////////////////////////////////////////////////////////////////////
	' //
	' // OposMicr.h
	' //
	' //   MICR header file for OPOS Applications.
	' //
	' // Modification history
	' // ------------------------------------------------------------------
	' // 1995-12-08 OPOS Release 1.0                                   CRM
	' // 2002-08-17 OPOS Release 1.7                                   CRM
	' //   Add new ResultCodeExtended constants.
	' // 2009-10-02 OPOS Release 1.13                                  CRM
	' //   Add CountryCode constants.
	' //
	' /////////////////////////////////////////////////////////////////////
	
	' /////////////////////////////////////////////////////////////////////
	' // "CheckType" Property Constants
	' /////////////////////////////////////////////////////////////////////
	
	Public Const MICR_CT_PERSONAL As Integer = 1
	Public Const MICR_CT_BUSINESS As Integer = 2
	Public Const MICR_CT_UNKNOWN As Integer = 99
	
	' /////////////////////////////////////////////////////////////////////
	' // "CountryCode" Property Constants
	' /////////////////////////////////////////////////////////////////////
	
	Public Const MICR_CC_USA As Integer = 1
	Public Const MICR_CC_CANADA As Integer = 2
	Public Const MICR_CC_MEXICO As Integer = 3
	Public Const MICR_CC_UNKNOWN As Integer = 99
	Public Const MICR_CC_CMC7 As Integer = 4 ' // Added in 1.13
	Public Const MICR_CC_OTHER As Integer = 5 ' // Added in 1.13
	
	' //////////////////////////////////////////////////////////////////////
	' // "ResultCodeExtended" Property Constants
	' /////////////////////////////////////////////////////////////////////
	
	Public Const OPOS_EMICR_NOCHECK As Integer = 201 ' // EndInsertion
	Public Const OPOS_EMICR_CHECK As Integer = 202 ' // EndRemoval
	
	' // The following were added in 1.7
	Public Const OPOS_EMICR_BADDATA As Integer = 203
	Public Const OPOS_EMICR_NODATA As Integer = 204
	Public Const OPOS_EMICR_BADSIZE As Integer = 205
	Public Const OPOS_EMICR_JAM As Integer = 206
	Public Const OPOS_EMICR_CHECKDIGIT As Integer = 207
	Public Const OPOS_EMICR_COVEROPEN As Integer = 208
	
	' /////////////////////////////////////////////////////////////////////
	' //
	' // OposMsr.h
	' //
	' //   Magnetic Stripe Reader header file for OPOS Applications.
	' //
	' // Modification history
	' // ------------------------------------------------------------------
	' // 1995-12-08 OPOS Release 1.0                                   CRM
	' // 1997-06-04 OPOS Release 1.2                                   CRM
	' //   Add ErrorReportingType constants.
	' // 2000-09-24 OPOS Release 1.5                                   BKS
	' //   Add constants relating to Track 4 Data.
	' //   (01-07-15 Added omitted MSR_TR_1_3_4 property)
	' // 2006-03-15 OPOS Release 1.10                                  CRM
	' //   Add values for the following properties:
	' //     CapWritableTracks, EncodingMaxLength, TracksToWrite
	' // 2008-08-30 OPOS Release 1.12                                  CRM
	' //   Add values for new properties, plus SUE and RCExt values.
	' //
	' /////////////////////////////////////////////////////////////////////
	
	' /////////////////////////////////////////////////////////////////////
	' // "TracksToRead", "CapWritableTracks", "TracksToWrite" Property Constants
	' /////////////////////////////////////////////////////////////////////
	
	Public Const MSR_TR_NONE As Integer = 0 ' // (added in 1.10)
	' // "CapWritableTracks", "TracksToWrite"
	
	Public Const MSR_TR_1 As Integer = 1
	Public Const MSR_TR_2 As Integer = 2
	Public Const MSR_TR_3 As Integer = 4
	Public Const MSR_TR_4 As Integer = 8 ' // (added in 1.5)
	
	Public Const MSR_TR_1_2 As Integer = &H3
	Public Const MSR_TR_1_3 As Integer = &H5
	Public Const MSR_TR_1_4 As Integer = &H9 ' // (added in 1.5)
	Public Const MSR_TR_2_3 As Integer = &H6
	Public Const MSR_TR_2_4 As Integer = &HA ' // (added in 1.5)
	Public Const MSR_TR_3_4 As Integer = &HC ' // (added in 1.5)
	
	Public Const MSR_TR_1_2_3 As Integer = &H7
	Public Const MSR_TR_1_2_4 As Integer = &HB ' // (added in 1.5)
	Public Const MSR_TR_1_3_4 As Integer = &HD ' // (added in 1.5)
	Public Const MSR_TR_2_3_4 As Integer = &HE ' // (added in 1.5)
	
	Public Const MSR_TR_1_2_3_4 As Integer = &HF ' // (added in 1.5)
	
	' /////////////////////////////////////////////////////////////////////
	' // "ErrorReportingType" Property Constants (added in 1.2)
	' /////////////////////////////////////////////////////////////////////
	
	Public Const MSR_ERT_CARD As Integer = 0
	Public Const MSR_ERT_TRACK As Integer = 1
	
	' /////////////////////////////////////////////////////////////////////
	' // "CapDataEncryption", "DataEncryptionAlgorithm" Property Constants
	' //   (added in 1.12)
	' /////////////////////////////////////////////////////////////////////
	
	Public Const MSR_DE_NONE As Integer = &H1
	Public Const MSR_DE_3DEA_DUKPT As Integer = &H2
	' // Note: Service-specific values begin at 0x01000000.
	
	' /////////////////////////////////////////////////////////////////////
	' // "CapDeviceAuthentication" Property Constants (added in 1.12)
	' /////////////////////////////////////////////////////////////////////
	
	Public Const MSR_DA_NOT_SUPPORTED As Integer = 0
	Public Const MSR_DA_OPTIONAL As Integer = 1
	Public Const MSR_DA_REQUIRED As Integer = 2
	
	' /////////////////////////////////////////////////////////////////////
	' // "DeviceAuthenticationProtocol" Property Constants (added in 1.12)
	' /////////////////////////////////////////////////////////////////////
	
	Public Const MSR_AP_NONE As Integer = 0
	Public Const MSR_AP_CHALLENGERESPONSE As Integer = 1
	
	' /////////////////////////////////////////////////////////////////////
	' // "CardType" Property Constants (added in 1.12)
	' /////////////////////////////////////////////////////////////////////
	
	Public Const MSR_CT_AAMVA As String = "AAMVA"
	Public Const MSR_CT_BANK As String = "BANK"
	
	' /////////////////////////////////////////////////////////////////////
	' // "RetrieveCardProperty" Method: "Name" Parameter Constants
	' //   (added in 1.12)
	' /////////////////////////////////////////////////////////////////////
	
	Public Const MSR_RCP_AccountNumber As String = "AccountNumber"
	Public Const MSR_RCP_Address As String = "Address"
	Public Const MSR_RCP_BirthDate As String = "BirthDate"
	Public Const MSR_RCP_City As String = "City"
	Public Const MSR_RCP_Class As String = "Class"
	Public Const MSR_RCP_Endorsements As String = "Endorsements"
	Public Const MSR_RCP_ExpirationDate As String = "ExpirationDate"
	Public Const MSR_RCP_EyeColor As String = "EyeColor"
	Public Const MSR_RCP_FirstName As String = "FirstName"
	Public Const MSR_RCP_Gender As String = "Gender"
	Public Const MSR_RCP_HairColor As String = "HairColor"
	Public Const MSR_RCP_Height As String = "Height"
	Public Const MSR_RCP_LicenseNumber As String = "LicenseNumber"
	Public Const MSR_RCP_MiddleInitial As String = "MiddleInitial"
	Public Const MSR_RCP_PostalCode As String = "PostalCode"
	Public Const MSR_RCP_Restrictions As String = "Restrictions"
	Public Const MSR_RCP_ServiceCode As String = "ServiceCode"
	Public Const MSR_RCP_State As String = "State"
	Public Const MSR_RCP_Suffix As String = "Suffix"
	Public Const MSR_RCP_Surname As String = "Surname"
	Public Const MSR_RCP_Title As String = "Title"
	Public Const MSR_RCP_Weight As String = "Weight"
	
	' /////////////////////////////////////////////////////////////////////
	' // "StatusUpdateEvent" Event: "Data" Parameter Constants
	' /////////////////////////////////////////////////////////////////////
	
	Public Const MSR_SUE_DEVICE_AUTHENTICATED As Integer = 11 ' // (added in 1.12)
	Public Const MSR_SUE_DEVICE_DEAUTHENTICATED As Integer = 12 ' // (added in 1.12)
	
	' /////////////////////////////////////////////////////////////////////
	' // "ErrorEvent" Event: "ResultCodeExtended" Parameter Constants
	' /////////////////////////////////////////////////////////////////////
	
	Public Const OPOS_EMSR_START As Integer = 201
	Public Const OPOS_EMSR_END As Integer = 202
	Public Const OPOS_EMSR_PARITY As Integer = 203
	Public Const OPOS_EMSR_LRC As Integer = 204
	Public Const OPOS_EMSR_DEVICE_AUTHENTICATION_FAILED As Integer = 205 ' // (added in 1.12)
	Public Const OPOS_EMSR_DEVICE_DEAUTHENTICATION_FAILED As Integer = 206 ' // (added in 1.12)
	
	' /////////////////////////////////////////////////////////////////////
	' //
	' // OposPtr.h
	' //
	' //   POS Printer header file for OPOS Applications.
	' //
	' // Modification history
	' // ------------------------------------------------------------------
	' // 1995-12-08 OPOS Release 1.0                                   CRM
	' // 1996-04-22 OPOS Release 1.1                                   CRM
	' //   Add CapCharacterSet constants.
	' //   Add ErrorLevel constants.
	' //   Add TransactionPrint's Control constants.
	' // 1997-06-04 OPOS Release 1.2                                   CRM
	' //   Remove PTR_RP_NORMAL_ASYNC.
	' //   Add more barcode symbologies.
	' // 1998-03-06 OPOS Release 1.3                                   CRM
	' //   Add more PrintTwoNormal constants.
	' // 2000-09-24 OPOS Release 1.5                             EPSON/BKS
	' //   Add CapRecMarkFeed and MarkFeed's Type constants.
	' //   Add ChangePrintSide constants.
	' //   Add StatusUpdateEvent constants.
	' //   Add ResultCodeExtended constants.
	' //   Add CapXxxCartridgeSensor and XxxCartridgeState constants.
	' //   Add CartridgeNotify constants.
	' //   Add CapCharacterset and CharacterSet constants for UNICODE.
	' // 2003-05-29 OPOS Release 1.7                                   CRM
	' //   Add more RotatePrint's Rotation PTR_RP_* constants.
	' // 2004-03-22 OPOS Release 1.8                                   CRM
	' //   Add more constants for PrintBarCode method and StatusUpdateEvent.
	' // 2004-10-26 Add "CharacterSet" ANSI constant (from 1.5).       CRM
	' // 2005-04-29 OPOS Release 1.9                                   CRM
	' //   Add PageModeDescriptor and PageModePrintDirection constants.
	' //   Add PageModePrint's Control constants.
	' // 2006-03-15 OPOS Release 1.10                                  CRM
	' //   Add PrintMemoryBitmap constants.
	' // 2008-08-30 OPOS Release 1.12                                  CRM
	' //   Add more constants for PrintBarCode method.
	' // 2009-10-02 OPOS Release 1.13                                  CRM
	' //   Add CapRecRuledLine and CapSlpRuledLine constants.
	' //   Add DrawRuledLine constants.
	' //   Add more constants for PrintBarCode method.
	' //
	' /////////////////////////////////////////////////////////////////////
	
	' /////////////////////////////////////////////////////////////////////
	' // Printer Station Constants
	' /////////////////////////////////////////////////////////////////////
	
	Public Const PTR_S_JOURNAL As Integer = 1
	Public Const PTR_S_RECEIPT As Integer = 2
	Public Const PTR_S_SLIP As Integer = 4
	
	Public Const PTR_S_JOURNAL_RECEIPT As Integer = &H3
	Public Const PTR_S_JOURNAL_SLIP As Integer = &H5
	Public Const PTR_S_RECEIPT_SLIP As Integer = &H6
	
	Public Const PTR_TWO_RECEIPT_JOURNAL As Integer = &H8003 ' // (added in 1.3)
	Public Const PTR_TWO_SLIP_JOURNAL As Integer = &H8005 ' // (added in 1.3)
	Public Const PTR_TWO_SLIP_RECEIPT As Integer = &H8006 ' // (added in 1.3)
	
	' /////////////////////////////////////////////////////////////////////
	' // "CapCharacterSet" Property Constants (added in 1.1)
	' /////////////////////////////////////////////////////////////////////
	
	Public Const PTR_CCS_ALPHA As Integer = 1
	Public Const PTR_CCS_ASCII As Integer = 998
	Public Const PTR_CCS_KANA As Integer = 10
	Public Const PTR_CCS_KANJI As Integer = 11
	Public Const PTR_CCS_UNICODE As Integer = 997 ' // (added in 1.5)
	
	' /////////////////////////////////////////////////////////////////////
	' // "CharacterSet" Property Constants
	' /////////////////////////////////////////////////////////////////////
	
	Public Const PTR_CS_UNICODE As Integer = 997 ' // (added in 1.5)
	Public Const PTR_CS_ASCII As Integer = 998
	Public Const PTR_CS_WINDOWS As Integer = 999
	Public Const PTR_CS_ANSI As Integer = 999
	
	' /////////////////////////////////////////////////////////////////////
	' // "ErrorLevel" Property Constants (added in 1.1)
	' /////////////////////////////////////////////////////////////////////
	
	Public Const PTR_EL_NONE As Integer = 1
	Public Const PTR_EL_RECOVERABLE As Integer = 2
	Public Const PTR_EL_FATAL As Integer = 3
	
	' /////////////////////////////////////////////////////////////////////
	' // "MapMode" Property Constants
	' /////////////////////////////////////////////////////////////////////
	
	Public Const PTR_MM_DOTS As Integer = 1
	Public Const PTR_MM_TWIPS As Integer = 2
	Public Const PTR_MM_ENGLISH As Integer = 3
	Public Const PTR_MM_METRIC As Integer = 4
	
	' /////////////////////////////////////////////////////////////////////
	' // "CapXxxColor" Property Constants
	' /////////////////////////////////////////////////////////////////////
	
	Public Const PTR_COLOR_PRIMARY As Integer = &H1
	Public Const PTR_COLOR_CUSTOM1 As Integer = &H2
	Public Const PTR_COLOR_CUSTOM2 As Integer = &H4
	Public Const PTR_COLOR_CUSTOM3 As Integer = &H8
	Public Const PTR_COLOR_CUSTOM4 As Integer = &H10
	Public Const PTR_COLOR_CUSTOM5 As Integer = &H20
	Public Const PTR_COLOR_CUSTOM6 As Integer = &H40
	Public Const PTR_COLOR_CYAN As Integer = &H100
	Public Const PTR_COLOR_MAGENTA As Integer = &H200
	Public Const PTR_COLOR_YELLOW As Integer = &H400
	Public Const PTR_COLOR_FULL As Integer = &H80000000
	
	' /////////////////////////////////////////////////////////////////////
	' // "CapXxxCartridgeSensor" and  "XxxCartridgeState" Property Constants
	' //   (added in 1.5)
	' /////////////////////////////////////////////////////////////////////
	
	Public Const PTR_CART_UNKNOWN As Integer = &H10000000
	Public Const PTR_CART_OK As Integer = &H0
	Public Const PTR_CART_REMOVED As Integer = &H1
	Public Const PTR_CART_EMPTY As Integer = &H2
	Public Const PTR_CART_NEAREND As Integer = &H4
	Public Const PTR_CART_CLEANING As Integer = &H8
	
	' /////////////////////////////////////////////////////////////////////
	' // "CartridgeNotify" Property Constants (added in 1.5)
	' /////////////////////////////////////////////////////////////////////
	
	Public Const PTR_CN_DISABLED As Integer = &H0
	Public Const PTR_CN_ENABLED As Integer = &H1
	
	' /////////////////////////////////////////////////////////////////////
	' // "PageModeDescriptor" Property Constants (added in 1.9)
	' /////////////////////////////////////////////////////////////////////
	
	Public Const PTR_PM_BITMAP As Integer = &H1
	Public Const PTR_PM_BARCODE As Integer = &H2
	Public Const PTR_PM_BM_ROTATE As Integer = &H4
	Public Const PTR_PM_BC_ROTATE As Integer = &H8
	Public Const PTR_PM_OPAQUE As Integer = &H10
	
	' /////////////////////////////////////////////////////////////////////
	' // "PageModePrintDirection" Property Constants (added in 1.9)
	' /////////////////////////////////////////////////////////////////////
	
	Public Const PTR_PD_LEFT_TO_RIGHT As Integer = 1
	Public Const PTR_PD_BOTTOM_TO_TOP As Integer = 2
	Public Const PTR_PD_RIGHT_TO_LEFT As Integer = 3
	Public Const PTR_PD_TOP_TO_BOTTOM As Integer = 4
	
	' /////////////////////////////////////////////////////////////////////
	' // "CutPaper" Method Constant
	' /////////////////////////////////////////////////////////////////////
	
	Public Const PTR_CP_FULLCUT As Integer = 100
	
	' /////////////////////////////////////////////////////////////////////
	' // "PageModePrint" Method: "Control" Parameter Constants (added in 1.9)
	' /////////////////////////////////////////////////////////////////////
	
	Public Const PTR_PM_PAGE_MODE As Integer = 1
	Public Const PTR_PM_PRINT_SAVE As Integer = 2
	Public Const PTR_PM_NORMAL As Integer = 3
	Public Const PTR_PM_CANCEL As Integer = 4
	
	' /////////////////////////////////////////////////////////////////////
	' // "PrintBarCode" Method Constants:
	' /////////////////////////////////////////////////////////////////////
	
	' //** "Alignment" Parameter
	' //     Either the distance from the left-most print column to the start
	' //     of the bar code, or one of the following:
	
	Public Const PTR_BC_LEFT As Integer = -1
	Public Const PTR_BC_CENTER As Integer = -2
	Public Const PTR_BC_RIGHT As Integer = -3
	
	' //** "TextPosition" Parameter
	
	Public Const PTR_BC_TEXT_NONE As Integer = -11
	Public Const PTR_BC_TEXT_ABOVE As Integer = -12
	Public Const PTR_BC_TEXT_BELOW As Integer = -13
	
	' //** "Symbology" Parameter:
	
	' //    - One dimensional symbologies
	Public Const PTR_BCS_UPCA As Integer = 101 ' // Digits
	Public Const PTR_BCS_UPCE As Integer = 102 ' // Digits
	Public Const PTR_BCS_JAN8 As Integer = 103 ' // = EAN 8
	Public Const PTR_BCS_EAN8 As Integer = 103 ' // = JAN 8 (added in 1.2)
	Public Const PTR_BCS_JAN13 As Integer = 104 ' // = EAN 13
	Public Const PTR_BCS_EAN13 As Integer = 104 ' // = JAN 13 (added in 1.2)
	Public Const PTR_BCS_TF As Integer = 105 ' // (Discrete 2 of 5) Digits
	Public Const PTR_BCS_ITF As Integer = 106 ' // (Interleaved 2 of 5) Digits
	Public Const PTR_BCS_Codabar As Integer = 107 ' // Digits, -, $, :, /, ., +;
	' //   4 start/stop characters
	' //   (a, b, c, d)
	Public Const PTR_BCS_Code39 As Integer = 108 ' // Alpha, Digits, Space, -, .,
	' //   $, /, +, %; start/stop (*)
	' // Also has Full ASCII feature
	Public Const PTR_BCS_Code93 As Integer = 109 ' // Same characters as Code 39
	Public Const PTR_BCS_Code128 As Integer = 110 ' // 128 data characters
	
	' //    - One dimensional symbologies (added in 1.2)
	Public Const PTR_BCS_UPCA_S As Integer = 111 ' // UPC-A with supplemental
	' //   barcode
	Public Const PTR_BCS_UPCE_S As Integer = 112 ' // UPC-E with supplemental
	' //   barcode
	Public Const PTR_BCS_UPCD1 As Integer = 113 ' // UPC-D1
	Public Const PTR_BCS_UPCD2 As Integer = 114 ' // UPC-D2
	Public Const PTR_BCS_UPCD3 As Integer = 115 ' // UPC-D3
	Public Const PTR_BCS_UPCD4 As Integer = 116 ' // UPC-D4
	Public Const PTR_BCS_UPCD5 As Integer = 117 ' // UPC-D5
	Public Const PTR_BCS_EAN8_S As Integer = 118 ' // EAN 8 with supplemental
	' //   barcode
	Public Const PTR_BCS_EAN13_S As Integer = 119 ' // EAN 13 with supplemental
	' //   barcode
	Public Const PTR_BCS_EAN128 As Integer = 120 ' // EAN 128
	Public Const PTR_BCS_OCRA As Integer = 121 ' // OCR "A"
	Public Const PTR_BCS_OCRB As Integer = 122 ' // OCR "B"
	
	' //    - One dimensional symbologies (added in 1.8)
	Public Const PTR_BCS_Code128_Parsed As Integer = 123 ' // Code 128 with parsing
	' //        The following RSS constants deprecated in 1.12.
	' //        Instead use the GS1DATABAR constants below.
	Public Const PTR_BCS_RSS14 As Integer = 131 ' // Reduced Space Symbology - 14 digit GTIN
	Public Const PTR_BCS_RSS_EXPANDED As Integer = 132 ' // RSS - 14 digit GTIN plus additional fields
	
	' //    - One dimensional symbologies (added in 1.12)
	Public Const PTR_BCS_GS1DATABAR As Integer = 131 ' // GS1 DataBar Omnidirectional
	Public Const PTR_BCS_GS1DATABAR_E As Integer = 132 ' // GS1 DataBar Expanded
	Public Const PTR_BCS_GS1DATABAR_S As Integer = 133 ' // GS1 DataBar Stacked Omnidirectional
	Public Const PTR_BCS_GS1DATABAR_E_S As Integer = 134 ' // GS1 DataBar Expanded Stacked
	
	' //    - Two dimensional symbologies
	Public Const PTR_BCS_PDF417 As Integer = 201
	Public Const PTR_BCS_MAXICODE As Integer = 202
	
	' //    - Two dimensional symbologies (added in 1.13)
	Public Const PTR_BCS_DATAMATRIX As Integer = 203 ' // Data Matrix
	Public Const PTR_BCS_QRCODE As Integer = 204 ' // QR Code
	Public Const PTR_BCS_UQRCODE As Integer = 205 ' // Micro QR Code
	Public Const PTR_BCS_AZTEC As Integer = 206 ' // Aztec
	Public Const PTR_BCS_UPDF417 As Integer = 207 ' // Micro PDF 417
	
	' //    - Start of Printer-Specific bar code symbologies
	Public Const PTR_BCS_OTHER As Integer = 501
	
	' /////////////////////////////////////////////////////////////////////
	' // "PrintBitmap" and "PrintMemoryBitmap" Method Constants:
	' /////////////////////////////////////////////////////////////////////
	
	' //** "Width" Parameter
	' //     Either bitmap width or:
	
	Public Const PTR_BM_ASIS As Integer = -11 ' // One pixel per printer dot
	
	' //** "Alignment" Parameter
	' //     Either the distance from the left-most print column to the start
	' //     of the bitmap, or one of the following:
	
	Public Const PTR_BM_LEFT As Integer = -1
	Public Const PTR_BM_CENTER As Integer = -2
	Public Const PTR_BM_RIGHT As Integer = -3
	
	' //** "Type" Parameter ("PrintMemoryBitmap" only)
	Public Const PTR_BMT_BMP As Integer = 1
	Public Const PTR_BMT_JPEG As Integer = 2
	Public Const PTR_BMT_GIF As Integer = 3
	
	' /////////////////////////////////////////////////////////////////////
	' // "RotatePrint" Method: "Rotation" Parameter Constants
	' // "RotateSpecial" Property Constants
	' /////////////////////////////////////////////////////////////////////
	
	Public Const PTR_RP_NORMAL As Integer = &H1
	Public Const PTR_RP_RIGHT90 As Integer = &H101
	Public Const PTR_RP_LEFT90 As Integer = &H102
	Public Const PTR_RP_ROTATE180 As Integer = &H103
	
	' // For "RotatePrint", one or both of the following values may be
	' // ORed with one of the above values.
	Public Const PTR_RP_BARCODE As Integer = &H1000 ' // (added in 1.7)
	Public Const PTR_RP_BITMAP As Integer = &H2000 ' // (added in 1.7)
	
	' /////////////////////////////////////////////////////////////////////
	' // "SetLogo" Method: "Location" Parameter Constants
	' /////////////////////////////////////////////////////////////////////
	
	Public Const PTR_L_TOP As Integer = 1
	Public Const PTR_L_BOTTOM As Integer = 2
	
	' /////////////////////////////////////////////////////////////////////
	' // "TransactionPrint" Method: "Control" Parameter Constants (added in 1.1)
	' /////////////////////////////////////////////////////////////////////
	
	Public Const PTR_TP_TRANSACTION As Integer = 11
	Public Const PTR_TP_NORMAL As Integer = 12
	
	' /////////////////////////////////////////////////////////////////////
	' // "MarkFeed" Method: "Type" Parameter Constants (added in 1.5)
	' // "CapRecMarkFeed" Property Constants (added in 1.5)
	' /////////////////////////////////////////////////////////////////////
	
	Public Const PTR_MF_TO_TAKEUP As Integer = 1
	Public Const PTR_MF_TO_CUTTER As Integer = 2
	Public Const PTR_MF_TO_CURRENT_TOF As Integer = 4
	Public Const PTR_MF_TO_NEXT_TOF As Integer = 8
	
	' /////////////////////////////////////////////////////////////////////
	' // "ChangePrintSide" Method: "Side" Parameter Constants (added in 1.5)
	' /////////////////////////////////////////////////////////////////////
	
	Public Const PTR_PS_UNKNOWN As Integer = 0
	Public Const PTR_PS_SIDE1 As Integer = 1
	Public Const PTR_PS_SIDE2 As Integer = 2
	Public Const PTR_PS_OPPOSITE As Integer = 3
	
	' /////////////////////////////////////////////////////////////////////
	' // "CapRecRuledLine" and "CapSlpRuledLine" Property Constants
	' // "DrawRuledLine" Method: "LineDirection" Parameter Constants
	' // (added in 1.13)
	' /////////////////////////////////////////////////////////////////////
	
	Public Const PTR_RL_HORIZONTAL As Integer = 1
	Public Const PTR_RL_VERTICAL As Integer = 2
	
	' /////////////////////////////////////////////////////////////////////
	' // "DrawRuledLine" Method: "LineStyle" Parameter Constants
	' // (added in 1.13)
	' /////////////////////////////////////////////////////////////////////
	
	Public Const PTR_LS_SINGLE_SOLID_LINE As Integer = 1
	Public Const PTR_LS_DOUBLE_SOLID_LINE As Integer = 2
	Public Const PTR_LS_BROKEN_LINE As Integer = 3
	Public Const PTR_LS_CHAIN_LINE As Integer = 4
	
	' /////////////////////////////////////////////////////////////////////
	' // "StatusUpdateEvent" Event: "Data" Parameter Constants
	' /////////////////////////////////////////////////////////////////////
	
	Public Const PTR_SUE_COVER_OPEN As Integer = 11
	Public Const PTR_SUE_COVER_OK As Integer = 12
	Public Const PTR_SUE_JRN_COVER_OPEN As Integer = 60 ' // (added in 1.8)
	Public Const PTR_SUE_JRN_COVER_OK As Integer = 61 ' // (added in 1.8)
	Public Const PTR_SUE_REC_COVER_OPEN As Integer = 62 ' // (added in 1.8)
	Public Const PTR_SUE_REC_COVER_OK As Integer = 63 ' // (added in 1.8)
	Public Const PTR_SUE_SLP_COVER_OPEN As Integer = 64 ' // (added in 1.8)
	Public Const PTR_SUE_SLP_COVER_OK As Integer = 65 ' // (added in 1.8)
	
	Public Const PTR_SUE_JRN_EMPTY As Integer = 21
	Public Const PTR_SUE_JRN_NEAREMPTY As Integer = 22
	Public Const PTR_SUE_JRN_PAPEROK As Integer = 23
	
	Public Const PTR_SUE_REC_EMPTY As Integer = 24
	Public Const PTR_SUE_REC_NEAREMPTY As Integer = 25
	Public Const PTR_SUE_REC_PAPEROK As Integer = 26
	
	Public Const PTR_SUE_SLP_EMPTY As Integer = 27
	Public Const PTR_SUE_SLP_NEAREMPTY As Integer = 28
	Public Const PTR_SUE_SLP_PAPEROK As Integer = 29
	
	Public Const PTR_SUE_JRN_CARTRIDGE_EMPTY As Integer = 41 ' // (added in 1.5)
	Public Const PTR_SUE_JRN_CARTRIDGE_NEAREMPTY As Integer = 42 ' // (added in 1.5)
	Public Const PTR_SUE_JRN_HEAD_CLEANING As Integer = 43 ' // (added in 1.5)
	Public Const PTR_SUE_JRN_CARTRIDGE_OK As Integer = 44 ' // (added in 1.5)
	
	Public Const PTR_SUE_REC_CARTRIDGE_EMPTY As Integer = 45 ' // (added in 1.5)
	Public Const PTR_SUE_REC_CARTRIDGE_NEAREMPTY As Integer = 46 ' // (added in 1.5)
	Public Const PTR_SUE_REC_HEAD_CLEANING As Integer = 47 ' // (added in 1.5)
	Public Const PTR_SUE_REC_CARTRIDGE_OK As Integer = 48 ' // (added in 1.5)
	
	Public Const PTR_SUE_SLP_CARTRIDGE_EMPTY As Integer = 49 ' // (added in 1.5)
	Public Const PTR_SUE_SLP_CARTRIDGE_NEAREMPTY As Integer = 50 ' // (added in 1.5)
	Public Const PTR_SUE_SLP_HEAD_CLEANING As Integer = 51 ' // (added in 1.5)
	Public Const PTR_SUE_SLP_CARTRIDGE_OK As Integer = 52 ' // (added in 1.5)
	
	Public Const PTR_SUE_IDLE As Integer = 1001
	
	' /////////////////////////////////////////////////////////////////////
	' // "ResultCodeExtended" Property Constants
	' /////////////////////////////////////////////////////////////////////
	
	Public Const OPOS_EPTR_COVER_OPEN As Integer = 201 ' // (Several)
	Public Const OPOS_EPTR_JRN_EMPTY As Integer = 202 ' // (Several)
	Public Const OPOS_EPTR_REC_EMPTY As Integer = 203 ' // (Several)
	Public Const OPOS_EPTR_SLP_EMPTY As Integer = 204 ' // (Several)
	Public Const OPOS_EPTR_SLP_FORM As Integer = 205 ' // EndRemoval
	Public Const OPOS_EPTR_TOOBIG As Integer = 206 ' // PrintBitmap
	Public Const OPOS_EPTR_BADFORMAT As Integer = 207 ' // PrintBitmap
	Public Const OPOS_EPTR_JRN_CARTRIDGE_REMOVED As Integer = 208 ' // (Several) (added in 1.5)
	Public Const OPOS_EPTR_JRN_CARTRIDGE_EMPTY As Integer = 209 ' // (Several) (added in 1.5)
	Public Const OPOS_EPTR_JRN_HEAD_CLEANING As Integer = 210 ' // (Several) (added in 1.5)
	Public Const OPOS_EPTR_REC_CARTRIDGE_REMOVED As Integer = 211 ' // (Several) (added in 1.5)
	Public Const OPOS_EPTR_REC_CARTRIDGE_EMPTY As Integer = 212 ' // (Several) (added in 1.5)
	Public Const OPOS_EPTR_REC_HEAD_CLEANING As Integer = 213 ' // (Several) (added in 1.5)
	Public Const OPOS_EPTR_SLP_CARTRIDGE_REMOVED As Integer = 214 ' // (Several) (added in 1.5)
	Public Const OPOS_EPTR_SLP_CARTRIDGE_EMPTY As Integer = 215 ' // (Several) (added in 1.5)
	Public Const OPOS_EPTR_SLP_HEAD_CLEANING As Integer = 216 ' // (Several) (added in 1.5)
	
	' /////////////////////////////////////////////////////////////////////
	' //
	' // OposScan.h
	' //
	' //   Scanner header file for OPOS Applications.
	' //
	' // Modification history
	' // ------------------------------------------------------------------
	' // 1995-12-08 OPOS Release 1.0                                   CRM
	' // 1997-06-04 OPOS Release 1.2                                   CRM
	' // 2004-03-22 OPOS Release 1.8                                   CRM
	' // 2007-01-30 OPOS Release 1.11                                  CRM
	' // 2008-08-30 OPOS Release 1.12                                  CRM
	' //   Add more constants for ScanDataType property.
	' //
	' /////////////////////////////////////////////////////////////////////
	
	' /////////////////////////////////////////////////////////////////////
	' // "ScanDataType" Property Constants (added in 1.2)
	' /////////////////////////////////////////////////////////////////////
	
	' // - One dimensional symbologies
	Public Const SCAN_SDT_UPCA As Integer = 101 ' // Digits
	Public Const SCAN_SDT_UPCE As Integer = 102 ' // Digits
	Public Const SCAN_SDT_JAN8 As Integer = 103 ' // = EAN 8
	Public Const SCAN_SDT_EAN8 As Integer = 103 ' // = JAN 8 (added in 1.2)
	Public Const SCAN_SDT_JAN13 As Integer = 104 ' // = EAN 13
	Public Const SCAN_SDT_EAN13 As Integer = 104 ' // = JAN 13 (added in 1.2)
	Public Const SCAN_SDT_TF As Integer = 105 ' // (Discrete 2 of 5) Digits
	Public Const SCAN_SDT_ITF As Integer = 106 ' // (Interleaved 2 of 5) Digits
	Public Const SCAN_SDT_Codabar As Integer = 107 ' // Digits, -, $, :, /, ., +;
	' //   4 start/stop characters
	' //   (a, b, c, d)
	Public Const SCAN_SDT_Code39 As Integer = 108 ' // Alpha, Digits, Space, -, .,
	' //   $, /, +, %; start/stop (*)
	' // Also has Full ASCII feature
	Public Const SCAN_SDT_Code93 As Integer = 109 ' // Same characters as Code 39
	Public Const SCAN_SDT_Code128 As Integer = 110 ' // 128 data characters
	
	Public Const SCAN_SDT_UPCA_S As Integer = 111 ' // UPC-A with supplemental
	' //   barcode
	Public Const SCAN_SDT_UPCE_S As Integer = 112 ' // UPC-E with supplemental
	' //   barcode
	Public Const SCAN_SDT_UPCD1 As Integer = 113 ' // UPC-D1
	Public Const SCAN_SDT_UPCD2 As Integer = 114 ' // UPC-D2
	Public Const SCAN_SDT_UPCD3 As Integer = 115 ' // UPC-D3
	Public Const SCAN_SDT_UPCD4 As Integer = 116 ' // UPC-D4
	Public Const SCAN_SDT_UPCD5 As Integer = 117 ' // UPC-D5
	Public Const SCAN_SDT_EAN8_S As Integer = 118 ' // EAN 8 with supplemental
	' //   barcode
	Public Const SCAN_SDT_EAN13_S As Integer = 119 ' // EAN 13 with supplemental
	' //   barcode
	Public Const SCAN_SDT_EAN128 As Integer = 120 ' // EAN 128
	Public Const SCAN_SDT_OCRA As Integer = 121 ' // OCR "A"
	Public Const SCAN_SDT_OCRB As Integer = 122 ' // OCR "B"
	
	' // - One dimensional symbologies (added in 1.8)
	' //        The following RSS constants deprecated in 1.12.
	' //        Instead use the GS1DATABAR constants below.
	Public Const SCAN_SDT_RSS14 As Integer = 131 ' // Reduced Space Symbology - 14 digit GTIN
	Public Const SCAN_SDT_RSS_EXPANDED As Integer = 132 ' // RSS - 14 digit GTIN plus additional fields
	
	' // - One dimensional symbologies (added in 1.12)
	Public Const SCAN_SDT_GS1DATABAR As Integer = 131 ' // GS1 DataBar Omnidirectional (normal or stacked)
	Public Const SCAN_SDT_GS1DATABAR_E As Integer = 132 ' // GS1 DataBar Expanded (normal or stacked)
	
	' // - Composite Symbologies (added in 1.8)
	Public Const SCAN_SDT_CCA As Integer = 151 ' // Composite Component A.
	Public Const SCAN_SDT_CCB As Integer = 152 ' // Composite Component B.
	Public Const SCAN_SDT_CCC As Integer = 153 ' // Composite Component C.
	
	' // - Two dimensional symbologies
	Public Const SCAN_SDT_PDF417 As Integer = 201
	Public Const SCAN_SDT_MAXICODE As Integer = 202
	
	' // - Two dimensional symbologies (added in 1.11)
	Public Const SCAN_SDT_DATAMATRIX As Integer = 203 ' // Data Matrix
	Public Const SCAN_SDT_QRCODE As Integer = 204 ' // QR Code
	Public Const SCAN_SDT_UQRCODE As Integer = 205 ' // Micro QR Code
	Public Const SCAN_SDT_AZTEC As Integer = 206 ' // Aztec
	Public Const SCAN_SDT_UPDF417 As Integer = 207 ' // Micro PDF 417
	
	' // - Special cases
	Public Const SCAN_SDT_OTHER As Integer = 501 ' // Start of Scanner-Specific bar
	' //   code symbologies
	Public Const SCAN_SDT_UNKNOWN As Integer = 0 ' // Cannot determine the barcode
	' //   symbology.
	
	' /////////////////////////////////////////////////////////////////////
	' //
	' // OposTot.h
	' //
	' //   Hard Totals header file for OPOS Applications.
	' //
	' // Modification history
	' // ------------------------------------------------------------------
	' // 1995-12-08 OPOS Release 1.0                                   CRM
	' //
	' /////////////////////////////////////////////////////////////////////
	
	' /////////////////////////////////////////////////////////////////////
	' // "ResultCodeExtended" Property Constants
	' /////////////////////////////////////////////////////////////////////
	
	Public Const OPOS_ETOT_NOROOM As Integer = 201 ' // Create, Write
	Public Const OPOS_ETOT_VALIDATION As Integer = 202 ' // Read, Write
End Module