Option Strict Off
Option Explicit On
Friend Class Step1
	Inherits System.Windows.Forms.Form
	'Step 1 Open cash drawer.
	
	Private Sub cmdExit_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdExit.Click
		
		Me.Close()
		
	End Sub
	
	
	'Open a drawer, and wait for closed
	'
	Private Sub Command1_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Command1.Click
		
		Me.Cursor = System.Windows.Forms.Cursors.WaitCursor
		Command1.Enabled = False
		
		'Open the drawer using the OpenDrawer method.
		OPOSCashDrawer1.OpenDrawer()
		
		' When the drawer is not closed in ten seconds after opening, beep until closed.
		' If executed the method, no values are returned until the drawer is closed.
		OPOSCashDrawer1.WaitForDrawerClose(10000, 2000, 100, 1000)
		
		Command1.Enabled = True
		Me.Cursor = System.Windows.Forms.Cursors.Default
		
	End Sub
	
	Private Sub Step1_Load(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles MyBase.Load
		
		With OPOSCashDrawer1
			'Open the device
			'Use a Logical Device Name which has been set on the SetupPOS.
			.Open("Unit1")
			
			'Get the exclusive control right for the opened device.
			'Then the device is disable from other application.
			
			'(Notice:When using an old CO, use the Claim.)
			.ClaimDevice(1000)
			
			'Enable the device.
			.DeviceEnabled = True
		End With
		
	End Sub
	
	Private Sub Step1_FormClosed(ByVal eventSender As System.Object, ByVal eventArgs As System.Windows.Forms.FormClosedEventArgs) Handles Me.FormClosed
		
		With OPOSCashDrawer1
			'Cancel the device
			.DeviceEnabled = False
			
			'Release the device exclusive control right.
			'(Notice:When using an old CO, use the Release.)
			.ReleaseDevice()
			
			'Finish using the device.
			.Close()
		End With
		
	End Sub
End Class