Option Strict Off
Option Explicit On
Friend Class Step4
	Inherits System.Windows.Forms.Form
	'Step 4 Adding error handlers.
	
	Private Sub cmdExit_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdExit.Click
		
		Me.Close()
		
	End Sub
	
	Private Sub cmdRetrieveSt_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdRetrieveSt.Click
		
		Dim strParam As String
		Dim lLen As Integer
		Dim strErrMsg As String
		Dim strXMLPath As String
		Dim strFindXMLPath As String
		
		strParam = txtRetrieveSt.Text
		strErrMsg = ""
		strFindXMLPath = ""
		
		' Obtains the statistics of the device and stores it in a file.
		With OPOSCashDrawer1
			.RetrieveStatistics(strParam)
			If (.ResultCode <> OPOS_SUCCESS) Then
				strErrMsg = "RetrieveStatistics method error." & vbCrLf & vbCrLf
				strErrMsg = strErrMsg & "ResultCode = " & CStr(.ResultCode) & vbCrLf
				strErrMsg = strErrMsg & "ResultCodeExtended = " & CStr(.ResultCodeExtended)
				MsgBox(strErrMsg, MsgBoxStyle.OKOnly + MsgBoxStyle.Exclamation, "CashDrawer")
				Exit Sub
			End If
		End With
		
		strXMLPath = My.Application.Info.DirectoryPath & "\Sample.xml"
		'Delete XML file.
		strFindXMLPath = Dir(strXMLPath)
		If strFindXMLPath <> "" Then
			Kill((strXMLPath))
		End If
		'Create XML file.
		FileOpen(1, strXMLPath, OpenMode.Binary, OpenAccess.Write)
		FilePut(1, strParam)
		FileClose(1)
		
		'Opens another window and indicates the information of the XML file.
		Step4Browser.Show()
		
	End Sub
	
	'Open a drawer
	'
	Private Sub Command1_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Command1.Click
		
		OPOSCashDrawer1.OpenDrawer()
		Select Case OPOSCashDrawer1.ResultCodeExtended
			Case OPOS_EPTR_COVER_OPEN
				MsgBox("OpenDrawer Error" & vbCrLf & "Printer Cover Open")
			Case OPOS_EPTR_JRN_EMPTY
				MsgBox("OpenDrawer Error" & vbCrLf & "Printer Journal Empty")
			Case OPOS_EPTR_REC_EMPTY
				MsgBox("OpenDrawer Error" & vbCrLf & "Printer Receipt Empty")
			Case Else
				If (OPOSCashDrawer1.ResultCode <> OPOS_SUCCESS) Then
					MsgBox("OpenDrawer Error")
				End If
		End Select
		
	End Sub
	
	Private Sub Step4_Load(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles MyBase.Load
		
		With OPOSCashDrawer1
			.Open("Unit1")
			' Error check
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("This device has not been registered, or cannot use.")
				GoTo LoadError
			End If
			
			.ClaimDevice(1000)
			' Error check
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Fails to get the exclusive right for the device.")
				GoTo LoadError
			End If
			
			' If support the CapPowerReporting, enable the Power Reporting Requirements.
			If .CapPowerReporting <> OPOS_PR_NONE Then
				.PowerNotify = OPOS_PN_ENABLED
			End If
			
			.DeviceEnabled = True
			' Error check
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Now the device is disable to use.")
				GoTo LoadError
			End If
			
			' Check whether enable to monitor the drawer open/close status, or not.
			If .CapStatus = True Then
				' Disable to monitor
				Frame1.Enabled = False
			End If
			
			' Set the edit box of parameter input.
			txtRetrieveSt.Text = "ModelName,HoursPoweredCount,DrawerGoodOpenCount"
			
			' Checks whether it has function to obtain
			' the statistics of devices.
			' If it does not have the function, invalidates
			' the [Retrieve Statistics] button and the edit box
			' of parameter input.
			If .CapStatisticsReporting = False Then
				cmdRetrieveSt.Enabled = False
				txtRetrieveSt.Enabled = False
			End If
			
		End With
		
		Exit Sub
		
LoadError: 
		' Nothing can be used.
		Dim OBJ As Object
		'All objects on the form
		For	Each OBJ In Me.Controls
			'Invalid exept for OPOS OCX
			If OBJ.Name <> "OPOSCashDrawer1" Then
				OBJ.Enabled = False
			End If
		Next OBJ
		cmdExit.Enabled = True 'Only the exit button is enabled.
		
	End Sub
	
	Private Sub Step4_FormClosed(ByVal eventSender As System.Object, ByVal eventArgs As System.Windows.Forms.FormClosedEventArgs) Handles Me.FormClosed
		
		With OPOSCashDrawer1
			.DeviceEnabled = False
			.ReleaseDevice()
			.Close()
		End With
		
	End Sub
	
	Private Sub OPOSCashDrawer1_StatusUpdateEvent(ByVal eventSender As System.Object, ByVal eventArgs As AxOposCashDrawer_CCO._IOPOSCashDrawerEvents_StatusUpdateEventEvent) Handles OPOSCashDrawer1.StatusUpdateEvent
		
		Select Case eventArgs.Data
			Case CASH_SUE_DRAWERCLOSED 'Drawer is closed
				Text1.Text = "Close"
			Case CASH_SUE_DRAWEROPEN 'Drawer is opened
				Text1.Text = "Open"
				'The Power Reporting Requirements fires the event when the device power status is changed.
			Case OPOS_SUE_POWER_ONLINE ' The device is powered on.
				Text2.Text = "ready"
			Case OPOS_SUE_POWER_OFF ' The device is powered off, or unconnected.
				Text2.Text = "OFF"
			Case OPOS_SUE_POWER_OFFLINE ' The device is powered on, but disable to operate.
				Text2.Text = "not ready"
			Case OPOS_SUE_POWER_OFF_OFFLINE ' The device is powered off or off-line.
				Text2.Text = "Offline"
		End Select
	End Sub
End Class