Option Strict Off
Option Explicit On
Friend Class Form1
	Inherits System.Windows.Forms.Form
	
	Private Sub AddMarkerButton_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles AddMarkerButton.Click
		
		With OPOSElectronicJournal1
			' Add marker to storage
			.AddMarker(MarkerEdit.Text)
			
			' Notify error
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Failed to Add Marker." & vbCrLf & "ResultCode = " & CStr(.ResultCode) & vbCrLf & "ResultCodeExtended = " & CStr(.ResultCodeExtended))
			End If
		End With
		
	End Sub
	
	Private Sub ExitButton_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles ExitButton.Click
		
		Me.Close()
		
	End Sub
	
	Private Sub Form1_Load(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles MyBase.Load
		
		With OPOSPOSPrinter1
			.Open("Unit1")
			'Check whether the device is succeed to open, or not
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Fails to open the POSPrinter device.")
				GoTo LoadErrorPtr
			End If
			
			.ClaimDevice(1000)
			'Check whether the device is claim to use, or not
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Fails to claim the POSPrinter device.")
				GoTo LoadErrorPtr
			End If
			
			If .CapPowerReporting <> OPOS_PR_NONE Then
				.PowerNotify = OPOS_PN_ENABLED
			End If
			
			.DeviceEnabled = True
			'Check whether the device is enable to use, or not
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Disable to use the POSPrinter device.")
				GoTo LoadErrorPtr
			End If
			
		End With
		
		With OPOSElectronicJournal1
			
			.Open("Unit1")
			'Check whether the device is succeed to open, or not
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Fails to open the ElectronicJournal device.")
				GoTo LoadErrorEJ
				Exit Sub
			End If
			
			.ClaimDevice(1000)
			'Check whether the device is claim to use, or not
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Fails to claim the ElectronicJournal device.")
				GoTo LoadErrorEJ
			End If
			
			.DeviceEnabled = True
			'Check whether the device is enable to use, or not
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Disable to use the ElectronicJournal device.")
				GoTo LoadErrorEJ
				Exit Sub
			End If
			
			.StorageEnabled = True
			'Check whether the device is store enabled to use, or not
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Disable to use the ElectronicJournal device.")
				StorageEnabledCheck.Enabled = .StorageEnabled
				GoTo LoadErrorEJ
				Exit Sub
			End If
			
			If .StorageEnabled Then
				StorageEnabledCheck.CheckState = System.Windows.Forms.CheckState.Checked
			Else
				GoTo LoadErrorEJ
				Exit Sub
			End If
			
		End With
		
		PrintButton.Enabled = True
		
		Exit Sub
		
LoadErrorPtr: 
		'Disable POSPrinter Control
		PrintButton.Enabled = False
		
		ExitButton.Enabled = True
		
LoadErrorEJ: 
		'Disable ElectronicJournal Control
		StorageEnabledCheck.Enabled = False
		AddMarkerButton.Enabled = False
		MarkerEdit.Enabled = False
		
		ExitButton.Enabled = True
		
	End Sub
	
	Private Sub Form1_FormClosed(ByVal eventSender As System.Object, ByVal eventArgs As System.Windows.Forms.FormClosedEventArgs) Handles Me.FormClosed
		
		With OPOSPOSPrinter1
			
			.DeviceEnabled = False
			.ReleaseDevice()
			.Close()
			
		End With
		
		With OPOSElectronicJournal1
			
			.DeviceEnabled = False
			.ReleaseDevice()
			.Close()
			
		End With
		
	End Sub
	
	
	Private Sub PrintButton_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles PrintButton.Click
		
		' Print receipt by POSPrinter.
		' For detail refer POSPrinter SampleProgram.
		Dim rcSpacing As Integer
		Dim rcHeight As Integer
		Dim ESC As New VB6.FixedLengthString(1)
		Dim fDate As String
		
		Cursor = System.Windows.Forms.Cursors.WaitCursor
		ESC.Value = Chr(&H1Bs)
		fDate = VB6.Format(Now, "mmmm dd, yyyy  AM/PM h:mm")
		
		With OPOSPOSPrinter1
			rcSpacing = .RecLineSpacing
			rcHeight = .RecLineHeight
			.TransactionPrint(PTR_S_RECEIPT, PTR_TP_TRANSACTION)
			
			.RotatePrint(PTR_S_RECEIPT, PTR_RP_LEFT90)
			
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|4C" & ESC.Value & "|bC" & "   Receipt     ")
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|3C" & ESC.Value & "|2uC" & "       Mr. Brawn" & vbCrLf)
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|2uC" & "                                                  " & vbCrLf & vbCrLf)
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|2uC" & ESC.Value & "|3C" & "        Total payment              $" & ESC.Value & "|4C" & "21.00  " & vbCrLf)
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|1C" & vbCrLf)
			.PrintNormal(PTR_S_RECEIPT, fDate & " Received" & vbCrLf & vbCrLf)
			.RecLineHeight = 24
			.RecLineSpacing = .RecLineHeight
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|uC" & " Details               " & vbCrLf)
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|1C" & "                          " & ESC.Value & "|2C" & "OPOS Store" & vbCrLf)
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|uC" & " Tax excluded    $20.00" & vbCrLf)
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|1C" & "                          " & ESC.Value & "|bC" & "Zip code 999-9999" & vbCrLf)
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|uC" & " Tax(5%)        $1.00" & ESC.Value & "|N" & "    Phone#(9999)99-9998" & vbCrLf)
			
			.RotatePrint(PTR_S_RECEIPT, PTR_RP_NORMAL)
			
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|fP")
			
			.TransactionPrint(PTR_S_RECEIPT, PTR_TP_NORMAL)
			
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Failed to Receipt print. " & vbCrLf & "ResultCode = " & CStr(.ResultCode) & vbCrLf & "ResultCodeExtended = " & CStr(.ResultCodeExtended))
			End If
			
			.RecLineSpacing = rcSpacing
			.RecLineHeight = rcHeight
		End With
		
		Cursor = System.Windows.Forms.Cursors.Default
		
	End Sub
	
	Private Sub StorageEnabledCheck_CheckStateChanged(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles StorageEnabledCheck.CheckStateChanged
		
		' ElectronicJournal storage Start / Stop
		Dim CheckBoxValue As Short
		With OPOSElectronicJournal1
			.StorageEnabled = StorageEnabledCheck.CheckState
			
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Failed to Storage Ready. " & vbCrLf & "ResultCode = " & CStr(.ResultCode) & vbCrLf & "ResultCodeExtended = " & CStr(.ResultCodeExtended))
			End If
			
			
			If .StorageEnabled Then
				CheckBoxValue = 1
			Else
				CheckBoxValue = 0
			End If
			
			StorageEnabledCheck.CheckState = CheckBoxValue
			
		End With
		
	End Sub
End Class