Option Strict Off
Option Explicit On
Friend Class Step14
	Inherits System.Windows.Forms.Form
	' Step 14  Device Statistics.
	
	
	Private Declare Sub Sleep Lib "kernel32" (ByVal sec As Integer)
	
	Private Structure ITEMDATA
		Dim Name_Renamed As String
		Dim Price As Integer
	End Structure
	
	
	Function GetErrorMsg() As String
		
		Dim BF As String
		
		'Make messages on each event information
		Select Case OPOSPOSPrinter1.ResultCodeExtended
			Case OPOS_EPTR_COVER_OPEN
				BF = "Printer cover is open."
			Case OPOS_EPTR_JRN_EMPTY
				BF = "No jurnal paper."
			Case OPOS_EPTR_REC_EMPTY
				BF = "No receipt paper."
			Case OPOS_EPTR_SLP_EMPTY
				BF = "No slip form."
			Case Else
				BF = "ResultCode = " & CStr(OPOSPOSPrinter1.ResultCode) & vbCrLf & "ResultCodeExtended = " & CStr(OPOSPOSPrinter1.ResultCodeExtended)
		End Select
		
		GetErrorMsg = BF
		
	End Function
	
	
	Private Function SlpInsertion() As Boolean
		
		Dim MSG As Integer
		Dim SlpPrintable As Integer
		Dim pMSG As String
		Dim bEndInsert As Boolean
		
		'Insert sheet
		SlpPrintable = 1
		bEndInsert = False
		
		With OPOSPOSPrinter1
			While SlpPrintable
				.BeginInsertion(500)
				'Check a sheet/Error check
				If (.ResultCode <> OPOS_SUCCESS) Then
					Select Case .ResultCode
						Case OPOS_E_TIMEOUT
							pMSG = "Insert slip."
							
						Case OPOS_E_ILLEGAL
							If (.SlpEmpty = True) Then
								pMSG = "Remove slip."
								bEndInsert = True
								.EndInsertion()
							Else
								pMSG = GetErrorMsg()
								.BeginRemoval(-1)
							End If
							
						Case Else
							pMSG = GetErrorMsg()
					End Select
					
					MSG = MsgBox(pMSG, MsgBoxStyle.RetryCancel, "Print credit sales slip ")
					If bEndInsert = True Then
						.EndInsertion()
						bEndInsert = False
					End If
					' Cancel
					If (MSG = MsgBoxResult.Cancel) Then
						.EndInsertion()
						.BeginRemoval(-1)
						.EndRemoval()
						SlpInsertion = False
						Exit Function
					End If
				Else
					.EndInsertion()
					pMSG = ""
					Select Case .ResultCode
						Case OPOS_E_EXTENDED
							If .ResultCodeExtended = OPOS_EPTR_SLP_EMPTY Then
								pMSG = "Insert slip."
							End If
							
						Case OPOS_SUCCESS
							'Slip is removed.
							If .SlpNearEnd = True Then
								.BeginRemoval(-1)
								pMSG = "Insert slip."
								'Cover is open.
							ElseIf .CoverOpen = True Then 
								pMSG = "Close the cover"
							Else
								SlpPrintable = 0
							End If
							
						Case OPOS_E_ILLEGAL
							If .CoverOpen = True And .SlpEmpty = True Then
								pMSG = "Insert slip"
								SlpPrintable = 0
							Else
								pMSG = "Insert slip"
								.Close()
								.Open("Unit1")
								.ClaimDevice(-1)
								.DeviceEnabled = True
							End If
					End Select
					
					If pMSG <> "" Then
						MSG = MsgBox(pMSG, MsgBoxStyle.RetryCancel, "Print credit sales slip ")
						If (MSG = MsgBoxResult.Cancel) Then
							.EndInsertion()
							.BeginRemoval(-1)
							.EndRemoval()
							SlpInsertion = False
							Exit Function
						End If
					End If
				End If
			End While
		End With
		
		SlpInsertion = True
		
	End Function
	
	
	Private Function SlpRemoval() As Boolean
		
		Dim pMSG As String
		Dim MSG As Integer
		Dim RecPrintable As Integer
		
		RecPrintable = 1
		With OPOSPOSPrinter1
			While RecPrintable
				.BeginRemoval(5000)
				If (.ResultCode <> OPOS_E_TIMEOUT) Then
					RecPrintable = 0
				Else
					MSG = MsgBox("Remove slip", MsgBoxStyle.OKOnly + MsgBoxStyle.Exclamation, "Print credit sales slip")
				End If
			End While
			If (.ResultCode <> OPOS_E_ILLEGAL) Then
				RecPrintable = 1
				While RecPrintable
					.EndRemoval()
					If (.ResultCode = OPOS_SUCCESS) Then
						RecPrintable = 0
					Else
						pMSG = GetErrorMsg()
						
						MSG = MsgBox(pMSG, MsgBoxStyle.RetryCancel + MsgBoxStyle.Question, "Print credit sales slip")
						'Canceled
						If (MSG = MsgBoxResult.Cancel) Then
							SlpRemoval = False
							Exit Function
						End If
					End If
				End While
			Else
				.EndRemoval()
			End If
		End With
		
		SlpRemoval = True
		
	End Function
	
	Private Function MakePrintString(ByRef lRecLineChars As Integer, ByRef sBuf As String, ByRef sPrice As String) As Object
		Dim sValue As String
		If lRecLineChars < (Len(sBuf) + Len(sPrice)) Then
			sValue = sBuf & sPrice
		Else
			sValue = sBuf & Space(lRecLineChars - (Len(sBuf) + Len(sPrice))) & sPrice
		End If
		
		MakePrintString = sValue
	End Function
	
	Private Sub cmdPrint_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdPrint.Click
		
		Dim bExit As Boolean
		Dim lValue As Integer
		Dim ESC As New VB6.FixedLengthString(1)
		Dim BcData As String
		
		If OPOSPOSPrinter1.CapRecPresent = False Then
			MsgBox("This Printer doesn't have Receipt Station.", MsgBoxStyle.Exclamation)
			Exit Sub
		End If
		
		' Initialization
		Cursor = System.Windows.Forms.Cursors.WaitCursor
		ESC.Value = Chr(&H1B)
		BcData = "4902720005074"
		bExit = False
		
		With OPOSPOSPrinter1
			.TransactionPrint(PTR_S_RECEIPT, PTR_TP_TRANSACTION)
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Cannot use a POS Printer.", MsgBoxStyle.Exclamation)
				Cursor = System.Windows.Forms.Cursors.Default
				Exit Sub
			End If
			
			'Loop
			Do 
				'Whether a bitmap can be used, or not.
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|4C" & "apple    $1.00" & vbLf)
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|200uF")
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|N" & ESC.Value & "|bC" & ESC.Value & "|cA" & "Best if used by Dec. 24, 2004" & vbLf)
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|200uF")
				If .CapRecBarCode = True Then
					.PrintBarCode(PTR_S_RECEIPT, BcData, PTR_BCS_EAN13, 500, .RecLineWidth / 3, PTR_BC_RIGHT, PTR_BC_TEXT_BELOW)
				End If
				
				'Feed the PTR_MF_TO_NEXT_TOF position.
				If (.CapRecMarkFeed And PTR_MF_TO_TAKEUP) Then
					.MarkFeed(PTR_MF_TO_TAKEUP)
				ElseIf (.CapRecMarkFeed And PTR_MF_TO_NEXT_TOF) Then 
					.MarkFeed(PTR_MF_TO_NEXT_TOF)
				End If
				
				If .ResultCode = OPOS_SUCCESS Then Exit Do
				
				'When error occurs, display a message to ask the user whether retry or not.
				Select Case MsgBox("Fails to output to a printer." & vbCrLf & vbCrLf & "Retry?", MsgBoxStyle.AbortRetryIgnore + MsgBoxStyle.Question)
					Case MsgBoxResult.Abort ' "Cancel"has been selected
						.ClearOutput()
						bExit = True
						Exit Do
					Case MsgBoxResult.Retry ' "Retry"has been selected.
						.ClearOutput()
					Case MsgBoxResult.Ignore ' "Ignore" has been selected.
						Exit Do
				End Select
			Loop 
			
			If bExit = False Then 'Has it been canceled?
				' Wait until device is 'OPOS_S_IDLE'
				While .CtlState <> OPOS_S_IDLE
					
				End While
				.TransactionPrint(PTR_S_RECEIPT, PTR_TP_NORMAL)
				If .ResultCode <> OPOS_SUCCESS Then
					MsgBox("Cannot use a POS Printer.", MsgBoxStyle.Exclamation)
					' Clear the buffered data since the buffer retains print data
					' when an error occurs during printing.
					.ClearOutput()
					Cursor = System.Windows.Forms.Cursors.Default
					Exit Sub
				End If
			End If
		End With
		
		Cursor = System.Windows.Forms.Cursors.Default
		
	End Sub
	
	Private Sub cmdAsync_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdAsync.Click
		
		Dim bExit As Boolean
		Dim ESC As New VB6.FixedLengthString(1)
		Dim BcData As String
		
		If OPOSPOSPrinter1.CapRecPresent = False Then
			MsgBox("This Printer doesn't have Receipt Station.", MsgBoxStyle.Exclamation)
			Exit Sub
		End If
		
		' Initialization
		Cursor = System.Windows.Forms.Cursors.WaitCursor
		ESC.Value = Chr(&H1B)
		BcData = "4902720005074"
		bExit = False
		
		With OPOSPOSPrinter1
			.AsyncMode = True
			.TransactionPrint(PTR_S_RECEIPT, PTR_TP_TRANSACTION)
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Cannot use a POS Printer.", MsgBoxStyle.Exclamation)
				.AsyncMode = False
				Cursor = System.Windows.Forms.Cursors.Default
				Exit Sub
			End If
			
			'Loop
			Do 
				'Whether a bitmap can be used, or not.
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|4C" & "apple    $1.00" & vbLf)
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|200uF")
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|N" & ESC.Value & "|bC" & ESC.Value & "|cA" & "Best if used by Dec. 24, 2004" & vbLf)
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|200uF")
				If .CapRecBarCode = True Then
					.PrintBarCode(PTR_S_RECEIPT, BcData, PTR_BCS_EAN13, 500, .RecLineWidth / 3, PTR_BC_RIGHT, PTR_BC_TEXT_BELOW)
				End If
				
				'Feed the PTR_MF_TO_NEXT_TOF position.
				If (.CapRecMarkFeed And PTR_MF_TO_TAKEUP) Then
					.MarkFeed(PTR_MF_TO_TAKEUP)
				ElseIf (.CapRecMarkFeed And PTR_MF_TO_NEXT_TOF) Then 
					.MarkFeed(PTR_MF_TO_NEXT_TOF)
				End If
				
				If .ResultCode = OPOS_SUCCESS Then Exit Do
				
				'When error occurs, display a message to ask the user whether retry or not.
				Select Case MsgBox("Fails to output to a printer" & vbCrLf & vbCrLf & "Retry?", MsgBoxStyle.AbortRetryIgnore + MsgBoxStyle.Question)
					Case MsgBoxResult.Abort ' "Cancel"has been selected
						.ClearOutput()
						bExit = True
						Exit Do
					Case MsgBoxResult.Retry ' "Retry" has been selected
						.ClearOutput()
					Case MsgBoxResult.Ignore ' "Ignore" has been selected
						Exit Do
				End Select
			Loop 
			
			If bExit = False Then 'Has it been canceled?
				.TransactionPrint(PTR_S_RECEIPT, PTR_TP_NORMAL)
				If .ResultCode <> OPOS_SUCCESS Then
					MsgBox("Cannot use a POS Printer.", MsgBoxStyle.Exclamation)
					.AsyncMode = False
					' Clear the buffered data since the buffer retains print data
					' when an error occurs during printing.
					.ClearOutput()
					Cursor = System.Windows.Forms.Cursors.Default
					Exit Sub
				End If
			End If
			.AsyncMode = False
		End With
		
		Cursor = System.Windows.Forms.Cursors.Default
		
	End Sub
	
	Private Sub cmdReceipt_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdReceipt.Click
		
		Dim bExit As Boolean
		Dim rcSpacing As Integer
		Dim rcHeight As Integer
		Dim ESC As New VB6.FixedLengthString(1)
		Dim RotateType As Integer
		Dim bBitmapPrint As Boolean
		Dim bBarcodePrint As Boolean
		Dim BcData As String
		
		If OPOSPOSPrinter1.CapRecPresent = False Then
			MsgBox("This Printer doesn't have Receipt Station.", MsgBoxStyle.Exclamation)
			Exit Sub
		End If
		
		'Check Rotate Function
		If OPOSPOSPrinter1.CapRecLeft90 = False Then
			MsgBox("This printer does not have a rotation printing function.", MsgBoxStyle.Exclamation)
			Exit Sub
		End If
		
		RotateType = 0
		bBitmapPrint = False
		bBarcodePrint = False
		With OPOSPOSPrinter1
			If .CapRecBitmap = True Then
				If InStr(.RecBitmapRotationList, "L90") <> 0 Then
					RotateType = RotateType + PTR_RP_BITMAP
					bBitmapPrint = True
				End If
			End If
			If .CapRecBarCode = True Then
				If InStr(.RecBarCodeRotationList, "L90") <> 0 Then
					RotateType = RotateType + PTR_RP_BARCODE
					bBarcodePrint = True
				End If
			End If
		End With
		
		
		' Initialization
		ESC.Value = Chr(&H1B)
		bExit = False
		BcData = "49027200"
		
		With OPOSPOSPrinter1
			'Batch processing mode
			.TransactionPrint(PTR_S_RECEIPT, PTR_TP_TRANSACTION)
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Cannot use a POS Printer.", MsgBoxStyle.Exclamation)
				Exit Sub
			End If
			
			'Rotate 90
			.RotatePrint(PTR_S_RECEIPT, PTR_RP_LEFT90 + RotateType)
			
			'Loop
			Do 
				rcSpacing = .RecLineSpacing 'Keep the default line spacing
				rcHeight = .RecLineHeight 'Keep the default line height
				
				If .CapRecBitmap = True Then
					.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|1B")
				End If
				'Printing process
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|4C" & ESC.Value & "|bC" & "apple" & vbCrLf)
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|2uC" & ESC.Value & "|4C" & "$1.00" & vbCrLf)
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|600uF")
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|N" & "Best if used " & vbLf)
				.PrintNormal(PTR_S_RECEIPT, "by" & vbLf)
				.PrintNormal(PTR_S_RECEIPT, "Dec. 24, 2004" & vbLf)
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|600uF")
				If .CapRecBarCode = True Then
					.PrintBarCode(PTR_S_RECEIPT, BcData, PTR_BCS_EAN8, 500, .RecLineWidth / 3, PTR_BC_RIGHT, PTR_BC_TEXT_BELOW)
				End If
				
				'When outputting normally,breakout of the loop.
				If .ResultCode = OPOS_SUCCESS Then Exit Do
				'When error occurs, display a message to ask the user whether retry or not.
				Select Case MsgBox("Fails to output to a printer." & vbCrLf & vbCrLf & "Retry?", MsgBoxStyle.AbortRetryIgnore + MsgBoxStyle.Question)
					Case MsgBoxResult.Abort ' "Cancel"has been selected
						'Clear all the buffer, and exit.
						.ClearOutput()
						bExit = True
						Exit Do
					Case MsgBoxResult.Retry ' "Retry"has been selected.
						'Clear all the buffer data, and retry.
						.ClearOutput()
					Case MsgBoxResult.Ignore '"Ignore" has been selected.
						Exit Do
				End Select
			Loop 
			
			.RotatePrint(PTR_S_RECEIPT, PTR_RP_NORMAL)
			
			If bExit = False Then
				If (.ResultCode = OPOS_SUCCESS) Then
					'Feed the PTR_MF_TO_NEXT_TOF position.
					If (.CapRecMarkFeed And PTR_MF_TO_TAKEUP) Then
						.MarkFeed(PTR_MF_TO_TAKEUP)
					ElseIf (.CapRecMarkFeed And PTR_MF_TO_NEXT_TOF) Then 
						.MarkFeed(PTR_MF_TO_NEXT_TOF)
					End If
				Else
					MsgBox("Cannot use a POS Printer" & vbCrLf & "ResultCode = " & CStr(.ResultCode) & vbCrLf & "ResultCodeExtended = " & CStr(.ResultCodeExtended), 0, "Print Receipt")
					.ClearOutput()
				End If
			End If
			
			' Wait until device is 'OPOS_S_IDLE'
			While .CtlState <> OPOS_S_IDLE
			End While
			'Print all the buffer data, and exit the batch processing mode.
			.TransactionPrint(PTR_S_RECEIPT, PTR_TP_NORMAL)
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Cannot use a POS Printer.", MsgBoxStyle.Exclamation)
				.RecLineSpacing = rcSpacing
				.RecLineHeight = rcHeight
				' Clear the buffered data since the buffer retains print data
				' when an error occurs during printing.
				.ClearOutput()
				Exit Sub
			End If
			
			.RecLineSpacing = rcSpacing
			.RecLineHeight = rcHeight
		End With
		
	End Sub
	
	Private Sub cmdPrintSales_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdPrintSales.Click
		
		Dim RecNo As Integer
		Dim ESC As New VB6.FixedLengthString(1)
		Dim fDate As String
		Dim fTime As String
		Dim fRecNo As String
		Dim fName As String
		Dim fSpace As String
		Dim OutputData As String
		
		'Request for inserting a slip
		If SlpInsertion() = False Then
			Exit Sub
		End If
		
		' Initialization
		Cursor = System.Windows.Forms.Cursors.WaitCursor
		ESC.Value = Chr(&H1B)
		fDate = VB6.Format(Today, "mmmm dd, yyyy") 'System date
		fTime = VB6.Format(TimeOfDay, "h:mm") 'System time
		RecNo = 1 'Register No.
		fRecNo = VB6.Format(RecNo, "  0000")
		fName = "ABCDEF" 'Casher No.
		If OPOSPOSPrinter1.SlpLineChars > 33 Then
			fSpace = Space(OPOSPOSPrinter1.SlpLineChars - 33) 'Left space
		Else
			fSpace = ""
		End If
		
		' Print data
		OutputData = vbCrLf & fSpace & "Print credit card sales slip" & vbCrLf
		OutputData = OutputData & ESC.Value & "|1lF"
		OutputData = OutputData & fSpace & "        SEIKO EPSON Corp." & vbCrLf
		OutputData = OutputData & fSpace & "Thank you for coming to our shop!" & vbCrLf
		OutputData = OutputData & ESC.Value & "|1lF"
		OutputData = OutputData & fSpace & "Date " & fDate & vbCrLf
		OutputData = OutputData & fSpace & "Time      " & fTime & "Casher   " & fName & vbCrLf
		OutputData = OutputData & fSpace & "Number of the register" & fRecNo & vbCrLf
		OutputData = OutputData & ESC.Value & "|N" & ESC.Value & "|1lF"
		OutputData = OutputData & fSpace & "Details                      cost" & vbCrLf
		OutputData = OutputData & fSpace & "Cardigan                 $ 100.00" & vbCrLf
		OutputData = OutputData & fSpace & "Shoes                     $ 70.00" & vbCrLf
		OutputData = OutputData & fSpace & "Hat                       $ 30.00" & vbCrLf
		OutputData = OutputData & fSpace & "Bag                      $ 150.00" & vbCrLf
		OutputData = OutputData & fSpace & "        Excluded tax     $ 350.00" & vbCrLf
		OutputData = OutputData & fSpace & "        Tax(5%)           $ 17.50" & vbCrLf
		OutputData = OutputData & fSpace & "        -------------------------" & vbCrLf
		OutputData = OutputData & fSpace & ESC.Value & "|2C     Total" & ESC.Value & "|1C     $ 367.50" & vbCrLf
		OutputData = OutputData & ESC.Value & "|1lF"
		OutputData = OutputData & fSpace & "Company name   EPSON-CARD" & vbCrLf
		OutputData = OutputData & fSpace & "Membership No. XXXXXXXXXXXXXXXX" & vbCrLf
		OutputData = OutputData & fSpace & "Valid date     12/05" & vbCrLf
		OutputData = OutputData & fSpace & "Handling No.   9999 - 999999" & vbCrLf
		OutputData = OutputData & fSpace & "Approval No.   99" & vbCrLf
		OutputData = OutputData & ESC.Value & "|1lF"
		OutputData = OutputData & fSpace & "Signature" & vbCrLf
		' Printing process
		OPOSPOSPrinter1.PrintNormal(PTR_S_SLIP, OutputData)
		If OPOSPOSPrinter1.ResultCode <> OPOS_SUCCESS Then
			MsgBox("Cannot use a POS Printer.", MsgBoxStyle.Exclamation)
			Cursor = System.Windows.Forms.Cursors.Default
			Exit Sub
		End If
		
		' Clean up
		Cursor = System.Windows.Forms.Cursors.Default
		
		'Remove the slip at the slip station.
		If SlpRemoval() = False Then
			'Fail
		End If
		
	End Sub
	
	Private Sub cmdExit_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdExit.Click
		
		Me.Close()
		
	End Sub
	
	Private Sub cmdRetrieveSt_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdRetrieveSt.Click
		
		Dim strParam As String
		Dim lLen As Integer
		Dim strErrMsg As String
		Dim strXMLPath As String
		Dim strFindXMLPath As String
		
		strParam = txtRetrieveSt.Text
		strErrMsg = ""
		strFindXMLPath = ""
		
		' Obtains the statistics of the device and stores it in a file.
		With OPOSPOSPrinter1
			'Obtains the statistics of the device.
			.RetrieveStatistics(strParam)
			If (.ResultCode <> OPOS_SUCCESS) Then
				strErrMsg = "RetrieveStatistics method error." & vbCrLf & vbCrLf
				strErrMsg = strErrMsg & "ResultCode = " & CStr(.ResultCode) & vbCrLf
				strErrMsg = strErrMsg & "ResultCodeExtended = " & CStr(.ResultCodeExtended)
				MsgBox(strErrMsg, MsgBoxStyle.OKOnly + MsgBoxStyle.Exclamation, "Printer")
				Exit Sub
			End If
		End With
		
		strXMLPath = My.Application.Info.DirectoryPath & "\Sample.xml"
		'Delete XML file.
		strFindXMLPath = Dir(strXMLPath)
		If strFindXMLPath <> "" Then
			Kill((strXMLPath))
		End If
		'Create XML File.
		FileOpen(1, strXMLPath, OpenMode.Binary, OpenAccess.Write)
		FilePut(1, strParam)
		FileClose(1)
		
		'Opens another window and indicates the information of the XML file.
		Step14Browser.Show()
		
	End Sub
	
	Private Sub OPOSPOSPrinter1_ErrorEvent(ByVal eventSender As System.Object, ByVal eventArgs As AxOposPOSPrinter_CCO._IOPOSPOSPrinterEvents_ErrorEventEvent) Handles OPOSPOSPrinter1.ErrorEvent
		
		Dim lRet As Integer
		
		lRet = MsgBox("Printer Error." & vbCrLf & vbCrLf & "ResultCode = " & CStr(eventArgs.ResultCode) & vbCrLf & "ResultCodeExtended = " & CStr(eventArgs.ResultCodeExtended), MsgBoxStyle.Information + MsgBoxStyle.RetryCancel)
		
		If lRet = MsgBoxResult.Cancel Then
			eventArgs.pErrorResponse = OPOS_ER_CLEAR
		End If
		
	End Sub
	
	Private Sub OPOSPOSPrinter1_OutputCompleteEvent(ByVal eventSender As System.Object, ByVal eventArgs As AxOposPOSPrinter_CCO._IOPOSPOSPrinterEvents_OutputCompleteEventEvent) Handles OPOSPOSPrinter1.OutputCompleteEvent
		
		'Notify that printing is completed when it is asnchronous.
		MsgBox("Complete printing", MsgBoxStyle.Information)
		
	End Sub
	
	
	Private Sub OPOSPOSPrinter1_StatusUpdateEvent(ByVal eventSender As System.Object, ByVal eventArgs As AxOposPOSPrinter_CCO._IOPOSPOSPrinterEvents_StatusUpdateEventEvent) Handles OPOSPOSPrinter1.StatusUpdateEvent
		'When there is a change of the status on the printer, the event is fired.
		
		Dim bRecEnb As Boolean
		
		bRecEnb = True
		
		'Make messages for the each event information.
		Select Case eventArgs.Data
			Case PTR_SUE_COVER_OPEN 'Printer cover is open.
				bRecEnb = False
			Case PTR_SUE_REC_EMPTY 'No receipt paper.
				bRecEnb = False
		End Select
		
		With OPOSPOSPrinter1
			'Check receipt function and set button state.
			If .CapRecPresent = True Then
				cmdPrint.Enabled = bRecEnb
				cmdAsync.Enabled = bRecEnb
				cmdReceipt.Enabled = bRecEnb
				Frame1.Enabled = bRecEnb
			Else
				cmdPrint.Enabled = False
				cmdAsync.Enabled = False
				cmdReceipt.Enabled = False
				Frame1.Enabled = False
			End If
			
			'Check rotate print function and set button state.
			If (.CapRecLeft90 = False) Or (.CapRecRight90 = False) Then
				cmdReceipt.Enabled = False
			End If
			
			'Check slip function and set button state.
			If (.CapSlpPresent = True) Then
				cmdPrintSales.Enabled = True
				Frame2.Enabled = True
			Else
				cmdPrintSales.Enabled = False
				Frame2.Enabled = False
			End If
		End With
		
		cmdExit.Enabled = True
		Frame2.Enabled = False
		
	End Sub
	
	
	Private Sub Step14_Load(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles MyBase.Load
		
		Dim strParam As String
		Dim RetryCount As Integer
		
		With OPOSPOSPrinter1
			.Open("Unit1")
			'Check whether the device is succeed to open, or not
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Fails to open the device.")
				GoTo LoadError
				Exit Sub
			End If
			
			.ClaimDevice(1000)
			'Check whether the device is claim to use, or not
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Fails to claim the device.")
				GoTo LoadError
			End If
			
			.DeviceEnabled = True
			'Check whether the device is enable to use, or not
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Disable to use the device.")
				GoTo LoadError
				Exit Sub
			End If
			
			.MapMode = PTR_MM_METRIC
			.RecLetterQuality = True
			
			If .CapRecBitmap = True Then
				RetryCount = 0
				Do While RetryCount < 5
					.SetBitmap(1, PTR_S_RECEIPT, My.Application.Info.DirectoryPath & "\Logo.bmp", .RecLineWidth / 2, PTR_BM_CENTER)
					If (.ResultCode = OPOS_E_ILLEGAL) And (.ResultCodeExtended = OPOS_EX_DEVBUSY) Then
						RetryCount = RetryCount + 1
						Sleep(1000)
					Else
						Exit Do
					End If
				Loop 
				
				If .ResultCode <> OPOS_SUCCESS Then
					MsgBox("Fails to set bitmap.")
					GoTo LoadError
				End If
			End If
			
			If (.CapRecLeft90 = False) Or (.CapRecRight90 = False) Then
				cmdReceipt.Enabled = False
			End If
			If (.CapSlpPresent = False) Or (.CapSlpFullslip = False) Then
				cmdPrintSales.Enabled = False
			End If
			
			' Set the edit box of parameter input.
			strParam = "ModelName,HoursPoweredCount"
			If .CapRecPresent = True Then
				strParam = strParam & ",ReceiptCharacterPrintedCount"
			ElseIf .CapSlpPresent = True Then 
				strParam = strParam & ",SlipCharacterPrintedCount"
			End If
			txtRetrieveSt.Text = strParam
			
			' Checks whether it has function to obtain
			' the statistics of devices.
			' If it does not have the function, invalidates
			' the [Retrieve Statistics] button and the edit box
			' of parameter input.
			If .CapStatisticsReporting = False Then
				cmdRetrieveSt.Enabled = False
				txtRetrieveSt.Enabled = False
				Frame5.Enabled = False
			End If
			
		End With
		
		Frame2.Enabled = False
		
		Exit Sub
		
		'Error disposal
LoadError: 
		Dim OBJ As Object
		'Disable all buttons
		For	Each OBJ In Me.Controls
			If OBJ.Name <> "OPOSPOSPrinter1" Then
				OBJ.Enabled = False
			End If
		Next OBJ
		'Enable to [Close] button only.
		cmdExit.Enabled = True
		
	End Sub
	
	Private Sub Step14_FormClosed(ByVal eventSender As System.Object, ByVal eventArgs As System.Windows.Forms.FormClosedEventArgs) Handles Me.FormClosed
		
		With OPOSPOSPrinter1
			.DeviceEnabled = False
			.ReleaseDevice()
			.Close()
		End With
		
	End Sub
End Class