Option Strict Off
Option Explicit On
Friend Class Step15
	Inherits System.Windows.Forms.Form
	' Step 15 PageMode-Prints
	
	
	Dim m_bStateCover As Boolean 'Cover open state
	Dim m_bStatePaper As Boolean 'Paper empty state
	Dim m_bCoverSensor As Boolean 'CapCoverSensor
	
	Private Declare Sub Sleep Lib "kernel32" (ByVal sec As Integer)
	
	Private Structure ITEMDATA
		Dim Name_Renamed As String
		Dim Price As Integer
	End Structure
	
	Function GetErrorMsg() As String
		
		Dim BF As String
		
		'Make messages on each event information
		Select Case OPOSPOSPrinter1.ResultCodeExtended
			Case OPOS_EPTR_COVER_OPEN
				BF = "Printer cover is open."
			Case OPOS_EPTR_JRN_EMPTY
				BF = "No jurnal paper."
			Case OPOS_EPTR_REC_EMPTY
				BF = "No receipt paper."
			Case OPOS_EPTR_SLP_EMPTY
				BF = "No slip form."
			Case Else
				BF = "ResultCode = " & CStr(OPOSPOSPrinter1.ResultCode) & vbCrLf & "ResultCodeExtended = " & CStr(OPOSPOSPrinter1.ResultCodeExtended)
		End Select
		
		GetErrorMsg = BF
		
	End Function
	
	Private Function SlpInsertion() As Boolean
		
		Dim MSG As Integer
		Dim SlpPrintable As Integer
		Dim pMSG As String
		Dim bEndInsert As Boolean
		
		'Insert sheet
		SlpPrintable = 1
		bEndInsert = False
		
		With OPOSPOSPrinter1
			While SlpPrintable
				.BeginInsertion(500)
				'Check a sheet/Error check
				If (.ResultCode <> OPOS_SUCCESS) Then
					Select Case .ResultCode
						Case OPOS_E_TIMEOUT
							pMSG = "Insert slip."
							
						Case OPOS_E_ILLEGAL
							If (.SlpEmpty = True) Then
								pMSG = "Remove slip."
								bEndInsert = True
								.EndInsertion()
							Else
								pMSG = GetErrorMsg()
								.BeginRemoval(-1)
							End If
							
						Case Else
							pMSG = GetErrorMsg()
					End Select
					
					MSG = MsgBox(pMSG, MsgBoxStyle.RetryCancel, "Print credit sales slip ")
					If bEndInsert = True Then
						.EndInsertion()
						bEndInsert = False
					End If
					' Cancel
					If (MSG = MsgBoxResult.Cancel) Then
						.EndInsertion()
						.BeginRemoval(-1)
						.EndRemoval()
						SlpInsertion = False
						Exit Function
					End If
				Else
					.EndInsertion()
					pMSG = ""
					Select Case .ResultCode
						Case OPOS_E_EXTENDED
							If .ResultCodeExtended = OPOS_EPTR_SLP_EMPTY Then
								pMSG = "Insert slip."
							End If
							
						Case OPOS_SUCCESS
							'Slip is removed.
							If .SlpNearEnd = True Then
								.BeginRemoval(-1)
								pMSG = "Insert slip."
								'Cover is open.
							ElseIf .CoverOpen = True Then 
								pMSG = "Close the cover"
							Else
								SlpPrintable = 0
							End If
							
						Case OPOS_E_ILLEGAL
							If .CoverOpen = True And .SlpEmpty = True Then
								pMSG = "Insert slip"
								SlpPrintable = 0
							Else
								pMSG = "Insert slip"
								.Close()
								.Open("Unit1")
								.ClaimDevice(-1)
								.DeviceEnabled = True
							End If
					End Select
					
					If pMSG <> "" Then
						MSG = MsgBox(pMSG, MsgBoxStyle.RetryCancel, "Print credit sales slip ")
						If (MSG = MsgBoxResult.Cancel) Then
							.EndInsertion()
							.BeginRemoval(-1)
							.EndRemoval()
							SlpInsertion = False
							Exit Function
						End If
					End If
				End If
			End While
		End With
		
		SlpInsertion = True
		
	End Function
	
	Private Function SlpRemoval() As Boolean
		
		Dim pMSG As String
		Dim MSG As Integer
		Dim RecPrintable As Integer
		
		RecPrintable = 1
		With OPOSPOSPrinter1
			While RecPrintable
				.BeginRemoval(5000)
				If (.ResultCode <> OPOS_E_TIMEOUT) Then
					RecPrintable = 0
				Else
					MSG = MsgBox("Remove slip", MsgBoxStyle.OKOnly + MsgBoxStyle.Exclamation, "Print credit sales slip")
				End If
			End While
			If (.ResultCode <> OPOS_E_ILLEGAL) Then
				RecPrintable = 1
				While RecPrintable
					.EndRemoval()
					If (.ResultCode = OPOS_SUCCESS) Then
						RecPrintable = 0
					Else
						pMSG = GetErrorMsg()
						
						MSG = MsgBox(pMSG, MsgBoxStyle.RetryCancel + MsgBoxStyle.Question, "Print credit sales slip")
						'Canceled
						If (MSG = MsgBoxResult.Cancel) Then
							SlpRemoval = False
							Exit Function
						End If
					End If
				End While
			Else
				.EndRemoval()
			End If
		End With
		
		SlpRemoval = True
		
	End Function
	
	Private Function MakePrintString(ByRef lRecLineChars As Integer, ByRef sBuf As String, ByRef sPrice As String) As Object
		Dim sValue As String
		If lRecLineChars < (Len(sBuf) + Len(sPrice)) Then
			sValue = sBuf & sPrice
		Else
			sValue = sBuf & Space(lRecLineChars - (Len(sBuf) + Len(sPrice))) & sPrice
		End If
		
		MakePrintString = sValue
	End Function
	
	Private Sub cmdPrint_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdPrint.Click
		
		Dim bExit As Boolean
		Dim lValue As Integer
		Dim i As Short
		Dim idBuf(5) As ITEMDATA
		Dim ESC As New VB6.FixedLengthString(1)
		Dim fDate As String
		Dim BcData As String
		Dim sBuf As String
		Dim sPrice As String
		Dim sValue As String
		Dim sRecLineChars() As String
		Dim lRecLineCharsCount As Integer
		
		If OPOSPOSPrinter1.CapRecPresent = False Then
			MsgBox("This Printer doesn't have Receipt Station.", MsgBoxStyle.Exclamation)
			Exit Sub
		End If
		
		' Initialization
		Cursor = System.Windows.Forms.Cursors.WaitCursor
		ESC.Value = Chr(&H1Bs)
		fDate = VB6.Format(Now, "mmmm dd, yyyy  AM/PM h:mm")
		BcData = "4902720005074"
		bExit = False
		
		' Make a data of the buying goods
		idBuf(0).Name_Renamed = "apples" : idBuf(0).Price = 10
		idBuf(1).Name_Renamed = "grapes" : idBuf(1).Price = 20
		idBuf(2).Name_Renamed = "bananas" : idBuf(2).Price = 30
		idBuf(3).Name_Renamed = "lemons" : idBuf(3).Price = 40
		idBuf(4).Name_Renamed = "oranges" : idBuf(4).Price = 50
		
		With OPOSPOSPrinter1
			.TransactionPrint(PTR_S_RECEIPT, PTR_TP_TRANSACTION)
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Cannot use a POS Printer.", MsgBoxStyle.Exclamation)
				Cursor = System.Windows.Forms.Cursors.Default
				Exit Sub
			End If
			
			'Loop
			Do 
				If .CapRecBitmap = True Then
					.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|1B")
				End If
				
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|N" & "123xxstreet,xxxcity,xxxxstate " & vbLf)
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|rA" & "TEL 9999-99-9999   C#2" & vbLf)
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|200uF")
				
				'Change of the font size
				lRecLineCharsCount = GetRecLineChars(sRecLineChars)
				If lRecLineCharsCount >= 2 Then
					.RecLineChars = CInt(sRecLineChars(1))
					.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|cA" & fDate & vbLf)
					.RecLineChars = CInt(sRecLineChars(0))
				Else
					.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|cA" & fDate & vbLf)
				End If
				
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|500uF")
				'Print buying goods
				lValue = 0
				For i = LBound(idBuf) To UBound(idBuf) - 1
					If .ResultCode <> OPOS_SUCCESS Then Exit For
					sBuf = idBuf(i).Name_Renamed
					lValue = lValue + idBuf(i).Price
					sPrice = VB6.Format(idBuf(i).Price, "$#.00")
					sValue = MakePrintString(.RecLineChars, sBuf, sPrice)
					.PrintNormal(PTR_S_RECEIPT, sValue & vbLf)
				Next 
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|200uF")
				'Print the total cost
				sBuf = "Before adding tax"
				sPrice = VB6.Format(lValue, "$#.00")
				sValue = MakePrintString(.RecLineChars, sBuf, sPrice)
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|bC" & sValue & vbLf)
				sBuf = "tax   5.0%"
				sPrice = VB6.Format(lValue * 0.05, "$#.00")
				sValue = MakePrintString(.RecLineChars, sBuf, sPrice)
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|N" & ESC.Value & "|uC" & sValue & vbLf)
				sBuf = "total"
				sPrice = VB6.Format(lValue * 1.05, "$#.00")
				sValue = MakePrintString(.RecLineChars \ 2, sBuf, sPrice)
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|N" & ESC.Value & "|bC" & ESC.Value & "|2C" & sValue & vbLf)
				sBuf = "Customer's payment"
				sPrice = VB6.Format(200, "$#.00")
				sValue = MakePrintString(.RecLineChars, sBuf, sPrice)
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|N" & sValue & vbLf)
				sBuf = "Change"
				sPrice = VB6.Format(200 - lValue * 1.05, "$#.00")
				sValue = MakePrintString(.RecLineChars, sBuf, sPrice)
				.PrintNormal(PTR_S_RECEIPT, sValue & vbLf)
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|500uF")
				
				If .CapRecBarCode = True Then
					.PrintBarCode(PTR_S_RECEIPT, BcData, PTR_BCS_JAN13, 1000, .RecLineWidth, PTR_BC_CENTER, PTR_BC_TEXT_BELOW)
				End If
				
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|" & CStr(.RecLinesToPaperCut) & "lF")
				If .CapRecPapercut = True Then
					.CutPaper(100)
				End If
				
				If .ResultCode = OPOS_SUCCESS Then Exit Do
				
				'When error occurs, display a message to ask the user whether retry or not.
				Select Case MsgBox("Fails to output to a printer." & vbCrLf & vbCrLf & "Retry?", MsgBoxStyle.AbortRetryIgnore + MsgBoxStyle.Question)
					Case MsgBoxResult.Abort ' "Cancel"has been selected
						.ClearOutput()
						bExit = True
						Exit Do
					Case MsgBoxResult.Retry ' "Retry"has been selected.
						.ClearOutput()
					Case MsgBoxResult.Ignore ' "Ignore" has been selected.
						Exit Do
				End Select
			Loop 
			
			If bExit = False Then 'Has it been canceled?
				' Wait until device is 'OPOS_S_IDLE'
				While .CtlState <> OPOS_S_IDLE
					
				End While
				.TransactionPrint(PTR_S_RECEIPT, PTR_TP_NORMAL)
				If .ResultCode <> OPOS_SUCCESS Then
					MsgBox("Cannot use a POS Printer.", MsgBoxStyle.Exclamation)
					' Clear the buffered data since the buffer retains print data
					' when an error occurs during printing.
					.ClearOutput()
					Cursor = System.Windows.Forms.Cursors.Default
					Exit Sub
				End If
			End If
		End With
		
		Cursor = System.Windows.Forms.Cursors.Default
		
	End Sub
	
	Private Function GetRecLineChars(ByRef sRecLineChars() As String) As Object
		Dim lIndex As Integer
		Dim lCount As Integer
		Dim sRecLineCharsList As String
		Dim i As Short
		Dim lStartIndex As Integer
		Dim lEndIndex As Integer
		
		
		sRecLineCharsList = OPOSPOSPrinter1.RecLineCharsList
		
		If Len(sRecLineCharsList) = 0 Then
			GetRecLineChars = 0
		Else
			'Calculate the element count.
			lCount = 1
			lIndex = InStr(1, sRecLineCharsList, ",")
			While lIndex <> 0
				lCount = lCount + 1
				lIndex = lIndex + 1
				lIndex = InStr(lIndex, sRecLineCharsList, ",")
			End While
			
			'Set the element to array.
			ReDim sRecLineChars(lCount)
			
			lStartIndex = 1
			For i = 0 To lCount - 1
				lEndIndex = InStr(lStartIndex, sRecLineCharsList, ",")
				If lEndIndex = 0 Then
					lEndIndex = Len(sRecLineCharsList)
				End If
				
				sRecLineChars(i) = Mid(sRecLineCharsList, lStartIndex, lEndIndex - 1)
				lStartIndex = lEndIndex + 1
			Next 
			
			GetRecLineChars = lCount
			
		End If
		
	End Function
	
	
	Private Sub cmdAsync_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdAsync.Click
		
		Dim bExit As Boolean
		Dim lValue As Integer
		Dim i As Short
		Dim idBuf(5) As ITEMDATA
		Dim ESC As New VB6.FixedLengthString(1)
		Dim fDate As String
		Dim BcData As String
		Dim sBuf As String
		Dim sPrice As String
		Dim sValue As String
		
		If OPOSPOSPrinter1.CapRecPresent = False Then
			MsgBox("This Printer doesn't have Receipt Station.", MsgBoxStyle.Exclamation)
			Exit Sub
		End If
		
		' Initialization
		Cursor = System.Windows.Forms.Cursors.WaitCursor
		ESC.Value = Chr(&H1Bs)
		fDate = VB6.Format(Now, "mmmm dd, yyyy  AM/PM h:mm")
		BcData = "4902720005074"
		bExit = False
		
		' Make a data of the buying goods
		idBuf(0).Name_Renamed = "apples" : idBuf(0).Price = 10
		idBuf(1).Name_Renamed = "grapes" : idBuf(1).Price = 20
		idBuf(2).Name_Renamed = "bananas" : idBuf(2).Price = 30
		idBuf(3).Name_Renamed = "lemons" : idBuf(3).Price = 40
		idBuf(4).Name_Renamed = "oranges" : idBuf(4).Price = 50
		
		With OPOSPOSPrinter1
			.AsyncMode = True
			.TransactionPrint(PTR_S_RECEIPT, PTR_TP_TRANSACTION)
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Cannot use a POS Printer.", MsgBoxStyle.Exclamation)
				.AsyncMode = False
				Cursor = System.Windows.Forms.Cursors.Default
				Exit Sub
			End If
			
			'Loop
			Do 
				If .CapRecBitmap = True Then
					.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|1B")
				End If
				
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|N" & "123xxstreet,xxxcity,xxxxstate " & vbLf)
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|rA" & "TEL 9999-99-9999   C#2" & vbLf)
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|200uF")
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|cA" & fDate & vbLf)
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|500uF")
				'Print buying goods
				lValue = 0
				For i = LBound(idBuf) To UBound(idBuf) - 1
					If .ResultCode <> OPOS_SUCCESS Then Exit For
					sBuf = idBuf(i).Name_Renamed
					lValue = lValue + idBuf(i).Price
					sPrice = VB6.Format(idBuf(i).Price, "$#.00")
					sValue = MakePrintString(.RecLineChars, sBuf, sPrice)
					.PrintNormal(PTR_S_RECEIPT, sValue & vbLf)
				Next 
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|200uF")
				'Print the total cost
				sBuf = "Tax excluded."
				sPrice = VB6.Format(lValue, "$#.00")
				sValue = MakePrintString(.RecLineChars, sBuf, sPrice)
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|bC" & sValue & vbLf)
				sBuf = "Tax  5.0%"
				sPrice = VB6.Format(lValue * 0.05, "$#.00")
				sValue = MakePrintString(.RecLineChars, sBuf, sPrice)
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|N" & ESC.Value & "|uC" & sValue & vbLf)
				sBuf = "Total"
				sPrice = VB6.Format(lValue * 1.05, "$#.00")
				sValue = MakePrintString(.RecLineChars \ 2, sBuf, sPrice) 'Because the width of characters of total is doubled, take this into consideration when computing.
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|N" & ESC.Value & "|bC" & ESC.Value & "|2C" & sValue & vbLf)
				sBuf = "Customer's payment"
				sPrice = VB6.Format(200, "$#.00")
				sValue = MakePrintString(.RecLineChars, sBuf, sPrice)
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|N" & sValue & vbLf)
				sBuf = "Change"
				sPrice = VB6.Format(200 - lValue * 1.05, "$#.00")
				sValue = MakePrintString(.RecLineChars, sBuf, sPrice)
				.PrintNormal(PTR_S_RECEIPT, sValue & vbLf)
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|500uF")
				
				If .CapRecBarCode = True Then
					.PrintBarCode(PTR_S_RECEIPT, BcData, PTR_BCS_JAN13, 1000, .RecLineWidth, PTR_BC_CENTER, PTR_BC_TEXT_BELOW)
				End If
				
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|" & CStr(.RecLinesToPaperCut) & "lF")
				If .CapRecPapercut = True Then
					.CutPaper(100)
				End If
				
				If .ResultCode = OPOS_SUCCESS Then Exit Do
				
				'When error occurs, display a message to ask the user whether retry or not.
				Select Case MsgBox("Fails to output to a printer" & vbCrLf & vbCrLf & "Retry?", MsgBoxStyle.AbortRetryIgnore + MsgBoxStyle.Question)
					Case MsgBoxResult.Abort ' "Cancel"has been selected
						.ClearOutput()
						bExit = True
						Exit Do
					Case MsgBoxResult.Retry ' "Retry" has been selected
						.ClearOutput()
					Case MsgBoxResult.Ignore ' "Ignore" has been selected
						Exit Do
				End Select
			Loop 
			
			If bExit = False Then 'Has it been canceled?
				.TransactionPrint(PTR_S_RECEIPT, PTR_TP_NORMAL)
				If .ResultCode <> OPOS_SUCCESS Then
					MsgBox("Cannot use a POS Printer.", MsgBoxStyle.Exclamation)
					.AsyncMode = False
					' Clear the buffered data since the buffer retains print data
					' when an error occurs during printing.
					.ClearOutput()
					Cursor = System.Windows.Forms.Cursors.Default
					Exit Sub
				End If
			End If
			.AsyncMode = False
		End With
		
		Cursor = System.Windows.Forms.Cursors.Default
		
	End Sub
	
	' <<< Step 12 >>>
	' Prints Bitmaps and Barcodes on receipts using the
	' RotatedPrinting mode of Bitmap and Barcode.
	' If your printing device's printing area is too narrow or small,
	' the original printing layout may not be kept intact.
	
	Private Sub cmdReceipt_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdReceipt.Click
		
		Dim bExit As Boolean
		Dim rcSpacing As Integer
		Dim rcHeight As Integer
		Dim ESC As New VB6.FixedLengthString(1)
		Dim fDate As String
		Dim BcData As String
		Dim RotateType As Integer
		Dim bBitmapPrint As Boolean
		Dim bBarcodePrint As Boolean
		
		'Sets BitmapMode to NORMAL
		'Dim pData As Long
		'Dim pString As String
		
		If OPOSPOSPrinter1.CapRecPresent = False Then
			MsgBox("This Printer doesn't have Receipt Station.", MsgBoxStyle.Exclamation)
			Exit Sub
		End If
		
		'Check Rotate Function
		If OPOSPOSPrinter1.CapRecLeft90 = False Then
			MsgBox("This printer doesn't have a rotation printing function.", MsgBoxStyle.Exclamation)
			Exit Sub
		End If
		
		RotateType = 0
		bBitmapPrint = False
		bBarcodePrint = False
		With OPOSPOSPrinter1
			If .CapRecBitmap = True Then
				If InStr(.RecBitmapRotationList, "L90") <> 0 Then
					RotateType = RotateType + PTR_RP_BITMAP
					bBitmapPrint = True
				End If
			End If
			If .CapRecBarCode = True Then
				If InStr(.RecBarCodeRotationList, "L90") <> 0 Then
					RotateType = RotateType + PTR_RP_BARCODE
					bBarcodePrint = True
				End If
			End If
		End With
		
		' Initialization
		ESC.Value = Chr(&H1Bs)
		bExit = False
		fDate = VB6.Format(Now, "mmmm dd, yyyy  AM/PM h:mm")
		BcData = "4902720005074"
		
		With OPOSPOSPrinter1
			'Batch processing mode
			.TransactionPrint(PTR_S_RECEIPT, PTR_TP_TRANSACTION)
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Cannot use a POS Printer.", MsgBoxStyle.Exclamation)
				Exit Sub
			End If
			'Rotate 90
			.RotatePrint(PTR_S_RECEIPT, PTR_RP_LEFT90 + RotateType)
			
			'Loop
			Do 
				rcSpacing = .RecLineSpacing 'Keep the default line spacing
				rcHeight = .RecLineHeight 'Keep the default line height
				
				'Printing process
				
				'Sets BitmapMode to NORMAL
				'pData = PTR_DI_BMP_NORMAL
				'pString = ""
				'.DirectIO PTR_DI_SET_BITMAP_MODE, pData, pString
				
				If (bBitmapPrint) Then
					.PrintBitmap(PTR_S_RECEIPT, My.Application.Info.DirectoryPath & "\Logo.bmp", .RecLineWidth / 5, PTR_BM_CENTER)
				End If
				
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|4C" & ESC.Value & "|bC" & "   Receipt     ")
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|3C" & ESC.Value & "|2uC" & "       Mr. Brawn" & vbCrLf)
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|2uC" & "                                                  " & vbCrLf)
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|2uC" & ESC.Value & "|3C" & "        Total payment              $" & ESC.Value & "|4C" & "21.00  ")
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|1C" & vbCrLf)
				.PrintNormal(PTR_S_RECEIPT, fDate & " Received" & vbCrLf & vbCrLf)
				.RecLineHeight = 24
				.RecLineSpacing = .RecLineHeight
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|uC" & " Details               " & vbCrLf)
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|1C" & "                          " & ESC.Value & "|2C" & "OPOS Store" & vbCrLf)
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|uC" & " Tax excluded    $20.00" & vbCrLf)
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|1C" & "                          " & ESC.Value & "|bC" & "Zip code 999-9999" & vbCrLf)
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|uC" & " Tax(5%)        $1.00" & ESC.Value & "|N" & "    Phone#(9999)99-9998" & vbCrLf & vbCrLf)
				
				If (bBarcodePrint) Then
					.PrintBarCode(PTR_S_RECEIPT, BcData, PTR_BCS_JAN13, 500, .RecLineWidth / 2, PTR_BC_CENTER, PTR_BC_TEXT_BELOW)
				End If
				
				'When outputting normally,breakout of the loop.
				If .ResultCode = OPOS_SUCCESS Then Exit Do
				'When error occurs, display a message to ask the user whether retry or not.
				Select Case MsgBox("Fails to output to a printer." & vbCrLf & vbCrLf & "Retry?", MsgBoxStyle.AbortRetryIgnore + MsgBoxStyle.Question)
					Case MsgBoxResult.Abort ' "Cancel"has been selected
						'Clear all the buffer, and exit.
						.ClearOutput()
						bExit = True
						Exit Do
					Case MsgBoxResult.Retry ' "Retry"has been selected.
						'Clear all the buffer data, and retry.
						.ClearOutput()
					Case MsgBoxResult.Ignore '"Ignore" has been selected.
						Exit Do
				End Select
			Loop 
			
			.RotatePrint(PTR_S_RECEIPT, PTR_RP_NORMAL)
			
			If bExit = False Then
				If (.ResultCode = OPOS_SUCCESS) Then
					.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|" & CStr(.RecLinesToPaperCut) & "lF")
					If .CapRecPapercut = True Then 'ut function, or not.
						.CutPaper(100)
					End If
				Else
					MsgBox("Cannot use a POS Printer" & vbCrLf & "ResultCode = " & CStr(.ResultCode) & vbCrLf & "ResultCodeExtended = " & CStr(.ResultCodeExtended), 0, "Print Receipt")
					.ClearOutput()
				End If
			End If
			
			' Wait until device is 'OPOS_S_IDLE'
			While .CtlState <> OPOS_S_IDLE
			End While
			'Print all the buffer data, and exit the batch processing mode.
			.TransactionPrint(PTR_S_RECEIPT, PTR_TP_NORMAL)
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Cannot use a POS Printer.", MsgBoxStyle.Exclamation)
				.RecLineSpacing = rcSpacing
				.RecLineHeight = rcHeight
				' Clear the buffered data since the buffer retains print data
				' when an error occurs during printing.
				.ClearOutput()
				Exit Sub
			End If
			
			.RecLineSpacing = rcSpacing
			.RecLineHeight = rcHeight
		End With
		
	End Sub
	
	' <<< Step 15 >>>
	' Prints coupon ticket on receipts using the PageModePrinting mode.
	' If your printing device's printing area is too narrow or small,
	' the original printing layout may not be kept intact.
	
	Private Sub cmdPageMode_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdPageMode.Click
		Dim lPMDescriptorList(2) As Integer
		Dim lGetPMDescriptor As Integer
		Dim lCount As Integer
		Dim lVPosition As Integer
		
		Dim bBitmapPrint As Boolean
		Dim bBarcodePrint As Boolean
		
		Dim ESC As New VB6.FixedLengthString(1)
		Dim fDate As String
		Dim BcData As String
		Dim strOutputData As String
		
		Dim strPMArea As String
		Dim strMaxHArea As String
		Dim strMaxVArea As String
		Dim strSetHPositon As String
		Dim strSetVPosition As String
		
		If OPOSPOSPrinter1.CapRecPresent = False Then
			MsgBox("This Printer doesn't have Receipt Station.", MsgBoxStyle.Exclamation)
			Exit Sub
		End If
		'Check PageMode Function
		If OPOSPOSPrinter1.CapRecPageMode = False Then
			MsgBox("This printer doesn't have a PageMode printing function.", MsgBoxStyle.Exclamation)
			Exit Sub
		End If
		
		' Initialization
		ESC.Value = Chr(&H1Bs)
		fDate = VB6.Format(Now, "mmmm dd, yyyy  AM/PM h:mm")
		BcData = "4902720005074"
		
		lPMDescriptorList(0) = PTR_PM_BM_ROTATE
		lPMDescriptorList(1) = PTR_PM_BC_ROTATE
		lPMDescriptorList(2) = PTR_PM_OPAQUE
		
		With OPOSPOSPrinter1
			.PageModeStation = PTR_S_RECEIPT
			lGetPMDescriptor = .PageModeDescriptor
			' Select of target station of PageMode
			For lCount = 2 To 0 Step -1
				If (lPMDescriptorList(lCount) <= lGetPMDescriptor) Then
					lGetPMDescriptor = lGetPMDescriptor - lPMDescriptorList(lCount)
					Select Case lCount
						Case 0
							If .CapRecBitmap = True Then
								If InStr(.RecBitmapRotationList, "R90") <> 0 Then
									bBitmapPrint = True
								End If
							End If
						Case 1
							If .CapRecBarCode = True Then
								If InStr(.RecBarCodeRotationList, "R90") <> 0 Then
									bBarcodePrint = True
								End If
							End If
					End Select
				End If
			Next 
			
			' Initialization of PageMode area
			.PageModePrintArea = "0,0,0,0"
			.PageModeHorizontalPosition = 0
			.PageModeVerticalPosition = 0
			
			.PageModePrintDirection = PTR_PD_LEFT_TO_RIGHT
			strPMArea = .PageModeArea
			' Gets the maximum size of PageMode area
			lCount = InStr(strPMArea, ",")
			strMaxHArea = Mid(strPMArea, 1, lCount - 1)
			strMaxVArea = Mid(strPMArea, lCount + 1)
			' first PageMode area
			strSetVPosition = Str(.RecLineSpacing * 2)
			strPMArea = "0,0," & strMaxHArea & "," & strSetVPosition
			.PageModePrintArea = strPMArea
			
			' PageMode
			.PageModePrint(PTR_PM_PAGE_MODE)
			
			strOutputData = "OPOS Store"
			lCount = (.RecLineChars - System.Text.Encoding.GetEncoding(437).GetByteCount(strOutputData)) / 4
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|4C" & ESC.Value & "|cA" & ESC.Value & "|2uC" & Space(lCount) & strOutputData & Space(lCount) & vbCrLf)
			' Right90
			If (Val(strMaxVArea) > 12000) Then
				' Setting of Vertical Maximum value
				strMaxVArea = "12000"
			End If
			' second PageMode area
			.PageModePrintArea = "0," & strSetVPosition & "," & strMaxHArea & "," & Str(Val(strMaxVArea) - Val(strSetVPosition))
			.PageModePrintDirection = PTR_PD_TOP_TO_BOTTOM
			' Printing bitmap
			If (bBitmapPrint) Then
				.PrintBitmap(PTR_S_RECEIPT, My.Application.Info.DirectoryPath & "\Logo.bmp", .RecLineWidth / 4, PTR_BM_LEFT)
			End If
			
			.PageModeHorizontalPosition = (.RecLineWidth / 4) + .RecLineSpacing
			.PageModeVerticalPosition = .RecLineSpacing
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|4CCoupon ticket" & vbCrLf)
			
			.PageModeVerticalPosition = 0
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|rA123xxStreet,xxCity,xxState" & vbCrLf)
			.PageModeVerticalPosition = .RecLineSpacing
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|rATEL 9999-99-9999" & vbCrLf)
			.PageModeVerticalPosition = .RecLineSpacing * 2
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|rA" & fDate & vbCrLf)
			
			.PageModeHorizontalPosition = 0
			lVPosition = .RecLineWidth / 4 'a criterion value of Vertical position
			.PageModeVerticalPosition = lVPosition
			.PrintNormal(PTR_S_RECEIPT, "The following amount will be deducted " & vbCrLf & "from your total sales at the register " & vbCrLf & "by showing us this coupon." & vbCrLf)
			.PageModeHorizontalPosition = (.RecLineWidth / .RecLineChars) * 3
			.PageModeVerticalPosition = lVPosition + (.RecLineSpacing * 4)
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|bCper coupon" & vbCrLf)
			
			.PageModeHorizontalPosition = 0
			.PageModeVerticalPosition = lVPosition + (.RecLineSpacing * 4)
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|2uC" & Space(36) & vbCrLf)
			.PageModeVerticalPosition = lVPosition + (.RecLineSpacing * 5)
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|4C" & ESC.Value & "|2uC      $1.00  OFF  " & vbCrLf)
			
			.PageModeHorizontalPosition = (.RecLineWidth / .RecLineChars) * 9
			.PageModeVerticalPosition = lVPosition + (.RecLineSpacing * 7)
			fDate = VB6.Format(Now, "mmmm dd,")
			fDate = fDate & Str(Val(VB6.Format(Now, "yyyy")) + 1)
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|bCExpiration Date : " & fDate & vbCrLf)
			' Printing Barcode
			If (bBarcodePrint) Then
				.PageModeHorizontalPosition = 0
				.PageModeVerticalPosition = .RecLineSpacing * 5
				.PrintBarCode(PTR_S_RECEIPT, BcData, PTR_BCS_JAN13, 1000, .RecLineWidth / 3, PTR_BC_RIGHT, PTR_BC_TEXT_BELOW)
			End If
			
			.PageModePrint(PTR_PM_NORMAL)
			
			If (.ResultCode = OPOS_SUCCESS) Then
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|" & CStr(.RecLinesToPaperCut) & "lF")
				If .CapRecPapercut = True Then 'ut function, or not.
					.CutPaper(100)
				End If
			Else
				MsgBox("Cannot use a POS Printer" & vbCrLf & "ResultCode = " & CStr(.ResultCode) & vbCrLf & "ResultCodeExtended = " & CStr(.ResultCodeExtended), 0, "Print Receipt")
				.PageModePrint(PTR_PM_CANCEL)
			End If
			
		End With
		
	End Sub
	
	Private Sub cmdPrintSales_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdPrintSales.Click
		
		Dim RecNo As Integer
		Dim ESC As New VB6.FixedLengthString(1)
		Dim fDate As String
		Dim fTime As String
		Dim fRecNo As String
		Dim fName As String
		Dim fSpace As String
		Dim OutputData As String
		Dim bValiFlg As Boolean
		
		'When Validation is used.
		'    Dim pData As Long
		'    Dim pString As String
		
		bValiFlg = False
		
		'When Validation is used.
		'    pData = PTR_DI_SLIP_VALIDATION
		'    bValiFlg = True
		'    OPOSPOSPrinter1.DirectIO PTR_DI_SELECT_SLIP, pData, pString
		
		'Request for inserting a slip
		If SlpInsertion() = False Then
			Exit Sub
		End If
		
		' Initialization
		Cursor = System.Windows.Forms.Cursors.WaitCursor
		ESC.Value = Chr(&H1Bs)
		fDate = VB6.Format(Today, "mmmm dd, yyyy") 'System date
		fTime = VB6.Format(TimeOfDay, "h:mm") 'System time
		RecNo = 1 'Register No.
		fRecNo = VB6.Format(RecNo, "  0000")
		fName = "ABCDEF" 'Casher No.
		If OPOSPOSPrinter1.SlpLineChars > 33 Then
			fSpace = Space(OPOSPOSPrinter1.SlpLineChars - 33) 'Left space
		Else
			fSpace = ""
		End If
		
		' Print data
		OutputData = vbCrLf & fSpace & "Print credit card sales slip" & vbCrLf
		OutputData = OutputData & ESC.Value & "|1lF"
		OutputData = OutputData & fSpace & "        SEIKO EPSON Corp." & vbCrLf
		OutputData = OutputData & fSpace & "Thank you for coming to our shop!" & vbCrLf
		OutputData = OutputData & ESC.Value & "|1lF"
		OutputData = OutputData & fSpace & "Date " & fDate & vbCrLf
		If (bValiFlg = False) Then
			OutputData = OutputData & fSpace & "Time      " & fTime & "Casher   " & fName & vbCrLf
			OutputData = OutputData & fSpace & "Number of the register" & fRecNo & vbCrLf
			OutputData = OutputData & ESC.Value & "|N" & ESC.Value & "|1lF"
			OutputData = OutputData & fSpace & "Details                      cost" & vbCrLf
			OutputData = OutputData & fSpace & "Cardigan                 $ 100.00" & vbCrLf
			OutputData = OutputData & fSpace & "Shoes                     $ 70.00" & vbCrLf
			OutputData = OutputData & fSpace & "Hat                       $ 30.00" & vbCrLf
			OutputData = OutputData & fSpace & "Bag                      $ 150.00" & vbCrLf
			OutputData = OutputData & fSpace & "        Excluded tax     $ 350.00" & vbCrLf
			OutputData = OutputData & fSpace & "        Tax(5%)           $ 17.50" & vbCrLf
			OutputData = OutputData & fSpace & "        -------------------------" & vbCrLf
			OutputData = OutputData & fSpace & ESC.Value & "|2C     Total" & ESC.Value & "|1C     $ 367.50" & vbCrLf
			OutputData = OutputData & ESC.Value & "|1lF"
			OutputData = OutputData & fSpace & "Company name   EPSON-CARD" & vbCrLf
			OutputData = OutputData & fSpace & "Membership No. XXXXXXXXXXXXXXXX" & vbCrLf
			OutputData = OutputData & fSpace & "Valid date     12/05" & vbCrLf
			OutputData = OutputData & fSpace & "Handling No.   9999 - 999999" & vbCrLf
			OutputData = OutputData & fSpace & "Approval No.   99" & vbCrLf
			OutputData = OutputData & ESC.Value & "|1lF"
			OutputData = OutputData & fSpace & "Signature" & vbCrLf
		End If
		' Printing process
		OPOSPOSPrinter1.PrintNormal(PTR_S_SLIP, OutputData)
		If OPOSPOSPrinter1.ResultCode <> OPOS_SUCCESS Then
			MsgBox("Cannot use a POS Printer.", MsgBoxStyle.Exclamation)
			Cursor = System.Windows.Forms.Cursors.Default
			Exit Sub
		End If
		
		' Clean up
		Cursor = System.Windows.Forms.Cursors.Default
		
		'Remove the slip at the slip station.
		If SlpRemoval() = False Then
			'Fail
		End If
		
		'When Validation is used.
		'    pData = PTR_DI_SLIP_FULLSLIP
		'    OPOSPOSPrinter1.DirectIO PTR_DI_SELECT_SLIP, pData, pString
		
	End Sub
	
	
	' <<< Step 11 >>>
	'Control the initial position of the printer using the Direct IO.
	'Useful for printing neatly.
	'
	Private Sub cmdShiftPrint_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdShiftPrint.Click
		
		'   ESC/POS command
		'       ESC = n             n = 1
		'           Explanation: Printer selection command
		'
		'       ESC $ nL nH         nL, nH = Voluntary nunber among 0-255
		'           Explanation: Move the printing position to nL + nH x 256 from the left side.
		
		Dim pData As Integer
		Dim pString As String
		
		pData = 0
		' Connect a printer directly.(Support Hydra connection)
		pString = Chr(&H1Bs) & "=" & Chr(1)
		' Move the printing position to nL + nH x 256 from the left side.
		pString = pString & Chr(&H1Bs) & "$" & Chr(100) & Chr(0)
		OPOSPOSPrinter1.DirectIO(PTR_DI_OUTPUT_NORMAL, pData, pString)
		If OPOSPOSPrinter1.ResultCode <> OPOS_SUCCESS Then
			MsgBox("Cannot use a POS Printer.", MsgBoxStyle.Exclamation)
			Exit Sub
		End If
		
		' Test printing
		OPOSPOSPrinter1.PrintNormal(PTR_S_RECEIPT, "DirectIO" & vbCrLf)
		If OPOSPOSPrinter1.ResultCode <> OPOS_SUCCESS Then
			MsgBox("Cannot use a POS Printer.", MsgBoxStyle.Exclamation)
			Exit Sub
		End If
		
	End Sub
	
	' <<< Step 11 >>>
	'In using Direct IO, use the NVRAM to print a bitmap .
	'
	Private Sub cmdNVRAM_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdNVRAM.Click
		
		Dim pData As Integer
		Dim pString As String
		
		' Needed to register the bitmap before using it.
		' TMLlogo can be start up individually from the Device Specific Settings of the SetupPOS.
		
		pData = 1 'Number of the registered bitmap.
		pString = ""
		OPOSPOSPrinter1.DirectIO(PTR_DI_PRINT_FLASH_BITMAP, pData, pString)
		If OPOSPOSPrinter1.ResultCode <> OPOS_SUCCESS Then
			MsgBox("Cannot use a POS Printer.", MsgBoxStyle.Exclamation)
			Exit Sub
		End If
		
		' Color bitmap or J7000/7100
		
		'    pData = 2097184     'Number of the registered bitmap.Keycode 32,32(High=32 Low=32); 2097184 = (High * 256& * 256&) + Low
		'    pString = ""
		'    OPOSPOSPrinter1.DirectIO PTR_DI_PRINT_FLASH_BITMAP2, pData, pString
		
		
	End Sub
	
	' <<< Step 11 >>>
	Private Sub cmdMaintenance_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdMaintenance.Click
		Dim Index As Short = cmdMaintenance.GetIndex(eventSender)
		
		Dim lCommand As Integer
		Dim lCounterNum As Integer
		Dim strCounter As String
		
		Select Case Combo1.SelectedIndex
			Case 0 'Advance paper(number of lines): Slip
				lCounterNum = &HAs
			Case 1 'Total number of printing characters: Slip(Front)
				lCounterNum = &HBs
			Case 2 'Slip paper feed in terms of number of lines:Roled sheet
				lCounterNum = &H14s
			Case 3 'Numbers of strike on sheet: Roled sheet
				lCounterNum = &H15s
			Case 4 'Number of the checks read
				lCounterNum = &H3Cs
			Case 5 'Working time of the printer
				lCounterNum = &H46s
		End Select
		
		Select Case Index
			Case 0 'Reset
				lCommand = PTR_DI_RESET_MAINTENANCE_COUNTER
			Case 1 'Get
				lCommand = PTR_DI_GET_MAINTENANCE_COUNTER
			Case 2 'Cumulative
				lCommand = PTR_DI_GET_MAINTENANCE_COUNTER
				lCounterNum = lCounterNum Or &H80s
		End Select
		
		'In using the DirectIO method, use functions of the maintenance counter.
		If OPOSPOSPrinter1.DirectIO(lCommand, lCounterNum, strCounter) = OPOS_SUCCESS Then
			If Index = 0 Then
				Text1.Text = "Success."
			Else
				Text1.Text = strCounter
			End If
		Else
			Text1.Text = "Error."
		End If
		
	End Sub
	
	Private Sub OPOSPOSPrinter1_ErrorEvent(ByVal eventSender As System.Object, ByVal eventArgs As AxOposPOSPrinter_CCO._IOPOSPOSPrinterEvents_ErrorEventEvent) Handles OPOSPOSPrinter1.ErrorEvent
		
		If (MsgBox("Printer Error." & vbCrLf & vbCrLf & "ResultCode = " & CStr(eventArgs.ResultCode) & vbCrLf & "ResultCodeExtended = " & CStr(eventArgs.ResultCodeExtended), MsgBoxStyle.OKCancel + MsgBoxStyle.Information) = MsgBoxResult.Cancel) Then
			eventArgs.pErrorResponse = OPOS_ER_CLEAR
		End If
		
	End Sub
	
	Private Sub OPOSPOSPrinter1_OutputCompleteEvent(ByVal eventSender As System.Object, ByVal eventArgs As AxOposPOSPrinter_CCO._IOPOSPOSPrinterEvents_OutputCompleteEventEvent) Handles OPOSPOSPrinter1.OutputCompleteEvent
		
		'Notify that printing is completed when it is asnchronous.
		MsgBox("Complete printing", MsgBoxStyle.Information)
		
	End Sub
	
	
	Private Sub OPOSPOSPrinter1_StatusUpdateEvent(ByVal eventSender As System.Object, ByVal eventArgs As AxOposPOSPrinter_CCO._IOPOSPOSPrinterEvents_StatusUpdateEventEvent) Handles OPOSPOSPrinter1.StatusUpdateEvent
		'When there is a change of the status on the printer, the event is fired.
		
		Dim bRecEnb As Boolean
		
		'Make messages for the each event information.
		Select Case eventArgs.Data
			Case PTR_SUE_COVER_OPEN 'Printer cover is open.
				m_bStateCover = False
			Case PTR_SUE_REC_EMPTY 'No receipt paper.
				m_bStatePaper = False
			Case PTR_SUE_COVER_OK 'Printer cover is close.
				m_bStateCover = True
			Case PTR_SUE_REC_PAPEROK 'Receipt paper is ok.
				m_bStatePaper = True
			Case PTR_SUE_REC_NEAREMPTY 'Receipt paper is ok.(Near Empty)
				m_bStatePaper = True
		End Select
		
		If m_bStatePaper = True And (m_bStateCover = True Or m_bCoverSensor = False) Then
			bRecEnb = True
		Else
			bRecEnb = False
		End If
		
		Dim OBJ As Object
		' All disable to print button.
		For	Each OBJ In Me.Controls
			If OBJ.Name <> "OPOSPOSPrinter1" Then
				OBJ.Enabled = bRecEnb
			End If
		Next OBJ
		' Enable to [Close] button only.
		cmdExit.Enabled = True
		
		With OPOSPOSPrinter1
			'Check Rotate Function
			If (.CapRecLeft90 = False) Or (.CapRecRight90 = False) Then
				cmdReceipt.Enabled = False
			End If
			'Check Slip Function.
			If (.CapSlpPresent = False) Or (.CapSlpFullslip = False) Then
				cmdPrintSales.Enabled = False
			End If
			'Check PageMode Function
			If (.CapRecPageMode = False) Then
				cmdPageMode.Enabled = False
			End If
			
		End With
		
	End Sub
	
	Private Sub cmdExit_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdExit.Click
		
		Me.Close()
		
	End Sub
	
	Private Sub Step15_Load(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles MyBase.Load
		
		Dim RetryCount As Integer
		
		With OPOSPOSPrinter1
			.Open("Unit1")
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Fails to open the device.")
				GoTo LoadError
			End If
			
			.ClaimDevice(1000)
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Fails to claim the device.")
				GoTo LoadError
			End If
			
			.DeviceEnabled = True
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Disable to use the device.")
				GoTo LoadError
			End If
			
			.MapMode = PTR_MM_METRIC
			.RecLetterQuality = True
			
			If .CapRecBitmap = True Then
				RetryCount = 0
				Do While RetryCount < 5
					.SetBitmap(1, PTR_S_RECEIPT, My.Application.Info.DirectoryPath & "\Logo.bmp", .RecLineWidth / 2, PTR_BM_CENTER)
					If (.ResultCode = OPOS_E_ILLEGAL) And (.ResultCodeExtended = OPOS_EX_DEVBUSY) Then
						RetryCount = RetryCount + 1
						Sleep(1000)
					Else
						Exit Do
					End If
				Loop 
				
				If .ResultCode <> OPOS_SUCCESS Then
					MsgBox("Fails to set bitmap.")
					GoTo LoadError
				End If
			End If
			
			If (.CapRecLeft90 = False) Or (.CapRecRight90 = False) Then
				cmdReceipt.Enabled = False
			End If
			If (.CapSlpPresent = False) Or (.CapSlpFullslip = False) Then
				cmdPrintSales.Enabled = False
			End If
			If (.CapRecPageMode = False) Then
				cmdPageMode.Enabled = False
			End If
			
			m_bStateCover = True
			m_bStatePaper = True
			m_bCoverSensor = .CapCoverSensor
			
		End With
		
		Combo1.SelectedIndex = 0
		Exit Sub
		
		' Error disposal
LoadError: 
		Dim OBJ As Object
		' All disable to print button.
		For	Each OBJ In Me.Controls
			If OBJ.Name <> "OPOSPOSPrinter1" Then
				OBJ.Enabled = False
			End If
		Next OBJ
		
		m_bStateCover = False
		m_bStatePaper = False
		m_bCoverSensor = False
		
		' Enable to [Close] button only.
		cmdExit.Enabled = True
		
	End Sub
	
	Private Sub Step15_FormClosed(ByVal eventSender As System.Object, ByVal eventArgs As System.Windows.Forms.FormClosedEventArgs) Handles Me.FormClosed
		
		With OPOSPOSPrinter1
			.DeviceEnabled = False
			.ReleaseDevice()
			.Close()
		End With
		
	End Sub
End Class