Option Strict Off
Option Explicit On
Friend Class Step2
	Inherits System.Windows.Forms.Form
	' Step 2  Print various types of characters.
	
	Private Sub cmdPrint_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdPrint.Click
		
		Dim ESC As New VB6.FixedLengthString(1)
		Dim fDate As String
		
		'Initialization
		ESC.Value = Chr(&H1Bs) 'ESC command
		fDate = VB6.Format(Now, "mmmm dd, yyyy  AM/PM h:mm") 'system date
		
		With OPOSPOSPrinter1
			'print
			'Print address
			'   ESC|N = Normal char
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|N" & "123xxstreet,xxxcity,xxxxstate " & vbLf)
			'Print phone number
			'   ESC|rA = Right side char
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|rA" & "TEL 9999-99-9999   C#2" & vbLf)
			'Print date
			'   ESC|cA = Centaring char
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|cA" & fDate & vbCrLf & vbCrLf)
			'Print buying goods
			.PrintNormal(PTR_S_RECEIPT, "apples                  $20.00" & vbCrLf)
			.PrintNormal(PTR_S_RECEIPT, "grapes                  $30.00" & vbCrLf)
			.PrintNormal(PTR_S_RECEIPT, "bananas                 $40.00" & vbCrLf)
			.PrintNormal(PTR_S_RECEIPT, "lemons                  $50.00" & vbCrLf)
			.PrintNormal(PTR_S_RECEIPT, "oranges                 $60.00" & vbCrLf & vbCrLf)
			'Print the total cost
			'   ESC|bC = Bold
			'   ESC|uC = Underline
			'   ESC|2C = Wide charcter
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|bC" & "Tax excluded.          $200.00" & ESC.Value & "|N" & vbCrLf)
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|uC" & "Tax  5.0%               $10.00" & ESC.Value & "|N" & vbCrLf)
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|bC" & ESC.Value & "|2C" & "Total   $210.00" & ESC.Value & "|N" & vbCrLf)
			.PrintNormal(PTR_S_RECEIPT, "Customer's payment     $250.00" & vbCrLf)
			.PrintNormal(PTR_S_RECEIPT, "Change                  $40.00" & vbCrLf & vbCrLf)
			
			'Feed the receipt to the cutter position automatically, and cut.
			'   ESC|#fP = Line Feed and Paper cut
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|fP")
		End With
		
	End Sub
	
	
	Private Sub cmdExit_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdExit.Click
		
		Me.Close()
		
	End Sub
	
	
	Private Sub Step2_Load(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles MyBase.Load
		
		With OPOSPOSPrinter1
			.Open("Unit1")
			.ClaimDevice(1000)
			.DeviceEnabled = True
		End With
		
	End Sub
	
	
	Private Sub Step2_FormClosed(ByVal eventSender As System.Object, ByVal eventArgs As System.Windows.Forms.FormClosedEventArgs) Handles Me.FormClosed
		
		With OPOSPOSPrinter1
			.DeviceEnabled = False
			.ReleaseDevice()
			.Close()
		End With
		
	End Sub
End Class